/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;

public class SQLQueryCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    @NotNull
    private final SQLEditorBase editor;
    @NotNull
    private final SQLCompletionRequest request;
    @NotNull
    private volatile List<ICompletionProposal> proposals = Collections.emptyList();

    public SQLQueryCompletionAnalyzer(@NotNull SQLEditorBase editor, @NotNull SQLCompletionRequest request) {
        this.editor = editor;
        this.request = request;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int position = this.request.getDocumentOffset();
        SQLQueryCompletionContext completionContext = this.editor.obtainCompletionContext(position);
        if (completionContext != null) {
            SQLQueryCompletionSet completionSet = completionContext.prepareProposal(monitor, position);
            this.proposals = new ArrayList<ICompletionProposal>(completionSet.getItems().size());
            for (SQLQueryCompletionItem item : completionSet.getItems()) {
                DBPNamedObject object = null;
                DBIcon image = switch (item.getKind()) {
                    case SQLQueryCompletionItemKind.UNKNOWN -> DBValueFormatting.getObjectImage((DBPObject)item.getObject());
                    case SQLQueryCompletionItemKind.RESERVED -> UIIcon.SQL_TEXT;
                    case SQLQueryCompletionItemKind.SUBQUERY_ALIAS -> DBIcon.TREE_TABLE_ALIAS;
                    case SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME -> DBIcon.TREE_FOREIGN_KEY_COLUMN;
                    case SQLQueryCompletionItemKind.NEW_TABLE_NAME -> DBIcon.TREE_TABLE;
                    case SQLQueryCompletionItemKind.USED_TABLE_NAME -> UIIcon.EDIT_TABLE;
                    case SQLQueryCompletionItemKind.TABLE_COLUMN_NAME -> DBIcon.TREE_COLUMN;
                    default -> throw new IllegalStateException("Unexpected completion item kind " + String.valueOf(item.getKind()));
                };
                this.proposals.add(new SQLCompletionProposal(this.request, item.getText(), item.getText(), item.getText().length(), (DBPImage)image, DBPKeywordType.OTHER, item.getDescription(), object, Collections.emptyMap()));
            }
        }
    }

    @NotNull
    public List<ICompletionProposal> getProposals() {
        return this.proposals;
    }
}

