/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextViewer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.utils.ListNode;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SQLBackgroundParsingJob {
    private static final Log log = Log.getLog(SQLBackgroundParsingJob.class);
    private static final boolean DEBUG = false;
    private static final long schedulingTimeoutMilliseconds = 500L;
    @NotNull
    private final OffsetKeyedTreeMap<QueuedRegionInfo> queuedForReparse = new OffsetKeyedTreeMap();
    @NotNull
    private final Object syncRoot = new Object();
    @NotNull
    private final SQLEditorBase editor;
    @NotNull
    private final SQLDocumentSyntaxContext context = new SQLDocumentSyntaxContext();
    @Nullable
    private IDocument document = null;
    @NotNull
    private final AbstractJob job = new AbstractJob("Background parsing job"){

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                SQLBackgroundParsingJob.this.doWork(monitor);
                return Status.OK_STATUS;
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
                return Status.CANCEL_STATUS;
            }
        }
    };
    private volatile boolean isRunning = false;
    private volatile int knownRegionStart = 0;
    private volatile int knownRegionEnd = 0;
    @NotNull
    private final DocumentLifecycleListener documentListener = new DocumentLifecycleListener();
    private final Set<Integer> knownIdentifierPartTerms = Set.of(Integer.valueOf(166), Integer.valueOf(192), Integer.valueOf(1), Integer.valueOf(198));

    public SQLBackgroundParsingJob(@NotNull SQLEditorBase editor) {
        this.editor = editor;
    }

    @NotNull
    public SQLDocumentSyntaxContext getCurrentContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getTextViewer() != null) {
                IDocument document;
                this.editor.getTextViewer().addTextInputListener((ITextInputListener)this.documentListener);
                this.editor.getTextViewer().addViewportListener((IViewportListener)this.documentListener);
                if (this.document == null && (document = this.editor.getTextViewer().getDocument()) != null) {
                    this.document = document;
                    this.document.addDocumentListener((IDocumentListener)this.documentListener);
                }
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.cancel();
            TextViewer textViewer = this.editor.getTextViewer();
            if (textViewer != null) {
                textViewer.removeViewportListener((IViewportListener)this.documentListener);
                textViewer.removeTextInputListener((ITextInputListener)this.documentListener);
                if (this.document != null) {
                    this.document.removeDocumentListener((IDocumentListener)this.documentListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SQLQueryCompletionContext obtainCompletionContext(int offset) {
        SQLScriptItemAtOffset scriptItem = null;
        do {
            Object object = this.syncRoot;
            synchronized (object) {
                if (scriptItem == null || this.queuedForReparse.size() == 0) {
                    scriptItem = this.context.findScriptItem(offset);
                    if (scriptItem == null) {
                        break;
                    }
                    if (!scriptItem.item.isDirty()) {
                        return this.prepareCompletionContext(scriptItem, offset);
                    }
                }
            }
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        } while (scriptItem != null);
        return SQLQueryCompletionContext.prepareOffquery((int)0);
    }

    @NotNull
    private SQLQueryCompletionContext prepareCompletionContext(@NotNull SQLScriptItemAtOffset scriptItem, int offset) {
        int position = offset - scriptItem.offset;
        SQLQueryModel model = scriptItem.item.getQueryModel();
        if (model != null) {
            STMTreeNode syntaxNode = model.getSyntaxNode();
            LSMInspections.SyntaxInspectionResult syntaxInspectionResult = LSMInspections.prepareAbstractSyntaxInspection((STMTreeNode)syntaxNode, (int)position);
            SQLQueryDataContext context = null;
            SQLQueryNodeModel node = model.findNodeContaining(position);
            SQLQueryLexicalScopeItem lexicalItem = null;
            if (node != null) {
                SQLQueryLexicalScope scope = node.findLexicalScope(position);
                if (scope != null) {
                    context = scope.getContext();
                    lexicalItem = scope.findItem(position);
                }
                if (context == null) {
                    context = node.getGivenDataContext();
                }
            }
            ArrayDeque<STMTreeTermNode> nameNodes = new ArrayDeque<STMTreeTermNode>();
            List allTerms = LSMInspections.prepareTerms((STMTreeNode)syntaxNode);
            int index = STMUtils.binarySearchByKey((List)allTerms, t -> t.getRealInterval().a, (Object)position, Comparator.comparingInt(k -> k));
            if (index < 0) {
                index = ~index - 1;
            }
            if (((STMTreeTermNode)allTerms.get((int)index)).getRealInterval().b == position - 1) {
                int i = index;
                while (i >= 0) {
                    STMTreeTermNode term = (STMTreeTermNode)allTerms.get(i);
                    if (!this.knownIdentifierPartTerms.contains(term.symbol.getType()) && (term.getStmParent() == null || term.getStmParent().getNodeKindId() != 271)) break;
                    nameNodes.addFirst(term);
                    --i;
                }
            }
            return SQLQueryCompletionContext.prepare((SQLScriptItemAtOffset)scriptItem, (DBCExecutionContext)this.editor.getExecutionContext(), (LSMInspections.SyntaxInspectionResult)syntaxInspectionResult, (SQLQueryDataContext)context, (SQLQueryLexicalScopeItem)lexicalItem, (STMTreeTermNode[])((STMTreeTermNode[])nameNodes.toArray(STMTreeTermNode[]::new)));
        }
        return SQLQueryCompletionContext.EMPTY;
    }

    @NotNull
    private SQLDocumentSyntaxContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeDocumentModification(DocumentEvent event) {
        this.cancel();
        int insertedLength = event.getText() == null ? 0 : event.getText().length();
        IRegion regionToReparse = this.context.applyDelta(event.getOffset(), event.getLength(), insertedLength);
        int reparseStart = regionToReparse.getOffset();
        int reparseLength = 0;
        reparseLength = regionToReparse.getLength() < Integer.MAX_VALUE ? regionToReparse.getLength() : (event.getOffset() + insertedLength > this.editor.getTextViewer().getBottomIndexEndOffset() ? event.getOffset() + insertedLength : this.editor.getTextViewer().getBottomIndexEndOffset() - reparseStart);
        Object object = this.syncRoot;
        synchronized (object) {
            int delta = insertedLength - event.getLength();
            if (delta > 0) {
                this.queuedForReparse.applyOffset(event.getOffset(), delta);
                this.enqueueToReparse(reparseStart, reparseLength);
            } else {
                ListNode keyOffsetsToRemove = null;
                OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(reparseStart);
                if (it.getCurrValue() != null || it.prev()) {
                    int firstAffectedReparseOffset = it.getCurrOffset();
                    if (firstAffectedReparseOffset < reparseStart && firstAffectedReparseOffset + ((QueuedRegionInfo)it.getCurrValue()).length > reparseStart + insertedLength) {
                        return;
                    }
                    keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)firstAffectedReparseOffset);
                }
                while (it.next()) {
                    keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)it.getCurrOffset());
                }
                ListNode kn = keyOffsetsToRemove;
                while (kn != null) {
                    this.queuedForReparse.removeAt(((Integer)kn.data).intValue());
                    kn = kn.next;
                }
                this.queuedForReparse.put(reparseStart, (Object)new QueuedRegionInfo(reparseLength));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueToReparse(int toParseStart, int toParseLength) {
        Object object = this.syncRoot;
        synchronized (object) {
            OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(toParseStart);
            QueuedRegionInfo region = (QueuedRegionInfo)it.getCurrValue();
            int regionOffset = it.getCurrOffset();
            if (region == null && it.prev()) {
                region = (QueuedRegionInfo)it.getCurrValue();
                regionOffset = it.getCurrOffset();
            }
            if (region != null && regionOffset <= toParseStart && regionOffset + region.length > toParseStart) {
                region.length = Math.max(region.length, toParseStart + toParseLength - regionOffset);
            } else {
                this.queuedForReparse.put(toParseStart, (Object)new QueuedRegionInfo(toParseLength));
            }
        }
    }

    private void ensureVisibleRangeIsParsed() {
        int endOffset;
        TextViewer viewer = this.editor.getTextViewer();
        if (viewer == null || viewer.getDocument() == null) {
            return;
        }
        Interval knownRange = new Interval(this.knownRegionStart, this.knownRegionEnd);
        int startOffset = viewer.getTopIndexStartOffset();
        Interval visibleRange = new Interval(startOffset, endOffset = viewer.getBottomIndexEndOffset());
        if (!knownRange.properlyContains(visibleRange)) {
            Interval unknownRange = visibleRange.differenceNotProperlyContained(knownRange);
            if (unknownRange == null) {
                unknownRange = visibleRange;
            }
            this.enqueueToReparse(unknownRange.a, unknownRange.length());
            this.schedule(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(@Nullable DocumentEvent event) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.editor.getRuleManager() == null || !this.editor.isAdvancedHighlightingEnabled() || !SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                return;
            }
            if (this.job.getState() != 4) {
                this.job.cancel();
            }
            this.job.schedule(500L * (long)(this.isRunning ? 2 : 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.job.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocument(@Nullable IDocument newDocument) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.document != null) {
                this.cancel();
            }
            if (newDocument != null && SQLEditorUtils.isSQLSyntaxParserApplied(this.editor.getEditorInput())) {
                this.document = newDocument;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.context.clear();
            this.queuedForReparse.clear();
            this.knownRegionEnd = 0;
            this.knownRegionStart = 0;
            this.ensureVisibleRangeIsParsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(DBRProgressMonitor jobMonitor) throws BadLocationException {
        SQLScriptElement lastElement;
        List elements;
        IProgressMonitor monitor;
        int workLength;
        int workOffset;
        TextViewer viewer;
        block29: {
            int index;
            SQLParserContext parserContext;
            block28: {
                block27: {
                    viewer = this.editor.getTextViewer();
                    if (viewer == null || this.editor.getRuleManager() == null) {
                        return;
                    }
                    Interval visibleFragment = (Interval)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<Interval>(){

                        public Interval runWithResult() {
                            if (viewer == null || viewer.getDocument() == null) {
                                return null;
                            }
                            int startOffset = viewer.getTopIndexStartOffset();
                            int endOffset = viewer.getBottomIndexEndOffset();
                            return new Interval(startOffset, endOffset);
                        }
                    });
                    if (visibleFragment == null) {
                        return;
                    }
                    try {
                        Object object = this.syncRoot;
                        synchronized (object) {
                            int docTailDelta;
                            this.isRunning = true;
                            int stepsToKeep = 2;
                            int rangeStart = Math.max(0, visibleFragment.a - visibleFragment.length() * stepsToKeep);
                            int rangeEnd = Math.max(0, visibleFragment.b + visibleFragment.length() * stepsToKeep);
                            Interval actualFragment = new Interval(rangeStart, rangeEnd);
                            Interval preservedRegion = this.context.dropInvisibleScriptItems(actualFragment);
                            this.knownRegionStart = preservedRegion.a;
                            this.knownRegionEnd = preservedRegion.b;
                            OffsetKeyedTreeMap.NodesIterator it = this.queuedForReparse.nodesIteratorAt(0);
                            workOffset = it.getCurrValue() != null || it.next() ? it.getCurrOffset() : 0;
                            it = this.queuedForReparse.nodesIteratorAt(Integer.MAX_VALUE);
                            workLength = it.getCurrValue() != null || it.prev() ? it.getCurrOffset() + ((QueuedRegionInfo)it.getCurrValue()).length - workOffset : 0;
                            Interval workInterval = new Interval(workOffset, workOffset + workLength);
                            if (!actualFragment.properlyContains(workInterval)) {
                                workInterval = actualFragment.intersection(workInterval);
                                workOffset = workInterval.a;
                                workLength = workInterval.length();
                            }
                            if ((docTailDelta = this.document.getLength() - (workOffset + workLength)) < 0) {
                                workLength += docTailDelta;
                            }
                            this.queuedForReparse.clear();
                        }
                    }
                    catch (Throwable ex) {
                        log.error((Object)ex);
                        return;
                    }
                    monitor = jobMonitor.getNestedMonitor();
                    if (workLength != 0) break block27;
                    monitor.done();
                    return;
                }
                parserContext = new SQLParserContext(this.editor.getDataSource(), this.editor.getSyntaxManager(), this.editor.getRuleManager(), this.document);
                elements = SQLScriptParser.extractScriptQueries((SQLParserContext)parserContext, (int)workOffset, (int)workLength, (boolean)false, (boolean)false, (boolean)false);
                if (!elements.isEmpty()) break block28;
                monitor.done();
                return;
            }
            SQLScriptElement element = SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)((SQLScriptElement)elements.get(0)).getOffset());
            if (element != null) {
                elements.set(0, element);
            }
            if (elements.size() > 1 && (element = SQLScriptParser.extractQueryAtPos((SQLParserContext)parserContext, (int)((SQLScriptElement)elements.get(index = elements.size() - 1)).getOffset())) != null) {
                elements.set(index, element);
            }
            if ((lastElement = (SQLScriptElement)elements.get(elements.size() - 1)) != null) break block29;
            monitor.done();
            return;
        }
        try {
            try {
                workOffset = ((SQLScriptElement)elements.get(0)).getOffset();
                workLength = lastElement.getOffset() + lastElement.getLength() - workOffset;
                boolean isReadMetadataForQueryAnalysis = this.editor.isReadMetadataForQueryAnalysisEnabled();
                DBCExecutionContext executionContext = this.editor.getExecutionContext();
                monitor.beginTask("Background query analysis for " + this.editor.getTitle(), 1 + elements.size());
                monitor.worked(1);
                int i = 1;
                for (SQLScriptElement element : elements) {
                    if (monitor.isCanceled()) break;
                    try {
                        SQLQueryModelRecognizer recognizer = new SQLQueryModelRecognizer(executionContext, isReadMetadataForQueryAnalysis);
                        SQLQueryModel queryModel = recognizer.recognizeQuery(element.getOriginalText(), RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
                        if (queryModel != null) {
                            SQLDocumentScriptItemSyntaxContext itemContext = this.context.registerScriptItemContext(element.getOriginalText(), queryModel, element.getOffset(), element.getLength());
                            itemContext.clear();
                            for (SQLQuerySymbolEntry entry : queryModel.getAllSymbols()) {
                                itemContext.registerToken(entry.getInterval().a, entry);
                            }
                            itemContext.refreshCompleted();
                        }
                    }
                    catch (Throwable ex) {
                        log.debug((Object)("Error while analyzing query text: " + element.getOriginalText()), ex);
                    }
                    monitor.worked(1);
                    monitor.setTaskName("Background query analysis: subtask #" + i++);
                }
                this.context.resetLastAccessCache();
            }
            catch (Throwable ex) {
                log.debug((Object)ex);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
        monitor.done();
        int parsedOffset = workOffset;
        int parsedLength = workLength;
        Object object = this.syncRoot;
        synchronized (object) {
            this.knownRegionStart = Math.min(this.knownRegionStart, parsedOffset);
            this.knownRegionEnd = Math.max(this.knownRegionEnd, parsedOffset + parsedLength);
            this.isRunning = false;
        }
        UIUtils.asyncExec(() -> viewer.invalidateTextPresentation(parsedOffset, parsedLength));
    }

    private class DocumentLifecycleListener
    implements IDocumentListener,
    ITextInputListener,
    IViewportListener {
        private DocumentLifecycleListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.beforeDocumentModification(event);
        }

        public void documentChanged(DocumentEvent event) {
            SQLBackgroundParsingJob.this.schedule(event);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                SQLBackgroundParsingJob.this.cancel();
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
                SQLBackgroundParsingJob.this.setDocument(newInput);
            }
        }

        public void viewportChanged(int verticalOffset) {
            SQLBackgroundParsingJob.this.ensureVisibleRangeIsParsed();
        }
    }

    private static class QueuedRegionInfo {
        public int length;

        public QueuedRegionInfo(int length) {
            this.length = length;
        }
    }
}

