/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.scripts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceCreator;
import org.jkiss.dbeaver.model.fs.DBFFileStoreProvider;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class ScriptsHandlerImpl
extends AbstractResourceHandler
implements DBPResourceCreator {
    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource) | 0x20;
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "script folder";
        }
        return "script";
    }

    @Nullable
    public String getResourceDescription(@NotNull IResource resource) {
        return SQLEditorUtils.getResourceDescription(resource);
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNodeFromResource((DBNNodeWithResource)node, resource);
        return node;
    }

    public void updateNavigatorNodeFromResource(@NotNull DBNNodeWithResource node, @NotNull IResource resource) {
        super.updateNavigatorNodeFromResource(node, resource);
        if (resource instanceof IFolder) {
            if (node instanceof DBNResource && ((DBNResource)node).isRootResource(resource)) {
                node.setResourceImage((DBPImage)DBIcon.TREE_SCRIPT_FOLDER);
            }
        } else {
            node.setResourceImage((DBPImage)DBIcon.TREE_SCRIPT);
        }
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        FileStoreEditorInput input = null;
        if (resource instanceof DBFFileStoreProvider) {
            input = new FileStoreEditorInput(((DBFFileStoreProvider)resource).getFileStore());
        } else if (resource instanceof IFile) {
            input = new FileEditorInput((IFile)resource);
        }
        if (input != null) {
            int matchFlags = 5;
            UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, SQLEditor.class.getName(), true, matchFlags);
        } else {
            super.openResource(resource);
        }
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        if (resource.getResource() instanceof IFile) {
            DBPDataSourceContainer dataSource = EditorUtils.getFileDataSource((IFile)((IFile)resource.getResource()));
            return dataSource == null ? null : Collections.singletonList(dataSource);
        }
        return null;
    }

    @NotNull
    public IResource createResource(@NotNull IFolder folder) throws CoreException, DBException {
        return SQLEditorHandlerOpenEditor.openNewEditor(new SQLNavigatorContext(), (ISelection)new StructuredSelection((Object)folder));
    }
}

