/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletionInfo;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLIndentSymbols;
import org.jkiss.dbeaver.ui.editors.sql.indent.StopCondition;

public class SQLHeuristicScanner
implements SQLIndentSymbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private IDocument document;
    private String partitioning;
    private String partition;
    private SQLSyntaxManager syntaxManager;
    private char lastChar;
    private int lastPos;
    private String lastToken;
    private final StopCondition _nonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition _nonWS = new NonWhitespace();
    private final StopCondition _nonIdent = new NonSQLIdentifierPartDefaultPartition();
    private final DelimiterCondition DELIMITER_CONDITION = new DelimiterCondition();

    public SQLHeuristicScanner(IDocument document, String partitioning, String partition, SQLSyntaxManager syntaxManager) {
        assert (document != null);
        assert (partitioning != null);
        assert (partition != null);
        this.document = document;
        this.partitioning = partitioning;
        this.partition = partition;
        this.syntaxManager = syntaxManager;
    }

    public SQLHeuristicScanner(IDocument document, SQLSyntaxManager syntaxManager) {
        this(document, "___sql_partitioning", "__dftl_partition_content_type", syntaxManager);
    }

    public int getPosition() {
        return this.lastPos;
    }

    public String getLastToken() {
        return this.lastToken;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.lastPos;
        if (Character.isJavaIdentifierPart(this.lastChar)) {
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? this.document.getLength() : bound) : pos;
            try {
                this.lastToken = this.document.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(this.lastToken);
        }
        return 0;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.lastPos;
        if (Character.isJavaIdentifierPart(this.lastChar)) {
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                this.lastToken = this.document.get(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(this.lastToken);
        }
        this.lastToken = String.valueOf(this.lastChar);
        return 0;
    }

    private int getToken(String s) {
        assert (s != null);
        Integer tokenKindId = this.syntaxManager.getDialect().getBlockCompletions().findTokenId(s);
        if (tokenKindId != null) {
            return tokenKindId;
        }
        DBPKeywordType keywordType = this.syntaxManager.getDialect().getKeywordType(s);
        if (keywordType == DBPKeywordType.KEYWORD) {
            return 30;
        }
        return 0;
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, _nonWS);
    }

    public boolean endsWithDelimiter(int position, int bound) {
        int endPos = this.scanBackward(bound, position, this.DELIMITER_CONDITION);
        try {
            return endPos > position && this.DELIMITER_CONDITION.isDelimiterChar(this.document.getChar(endPos));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        assert (start >= 0);
        if (bound == -2) {
            bound = this.document.getLength();
        }
        assert (bound <= this.document.getLength());
        try {
            this.lastPos = start;
            while (this.lastPos < bound) {
                this.lastChar = this.document.getChar(this.lastPos);
                if (condition.stop(this.lastChar, this.lastPos, true)) {
                    return this.lastPos;
                }
                ++this.lastPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        assert (bound >= -1);
        assert (start < this.document.getLength());
        try {
            this.lastPos = start;
            while (this.lastPos > bound) {
                this.lastChar = this.document.getChar(this.lastPos);
                if (condition.stop(this.lastChar, this.lastPos, false)) {
                    return this.lastPos;
                }
                --this.lastPos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public boolean isDefaultPartition(int position) {
        assert (position >= 0);
        assert (position <= this.document.getLength());
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)position, (boolean)false);
            return region.getType().equals(this.partition);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int findOpeningPeer(int start, SQLBlockCompletionInfo blockInfo) {
        int token;
        assert (start < this.document.getLength());
        int openingPeer = blockInfo.getHeadTokenId();
        int closingPeer = blockInfo.getTailTokenId();
        int closingPeerEnd = blockInfo.getTailEndTokenId() != null ? blockInfo.getTailEndTokenId() : -2;
        int headCancelToken = blockInfo.getHeadCancelTokenId() != null ? blockInfo.getHeadCancelTokenId() : -2;
        int depth = 1;
        int nextToken = -1;
        int offset = ++start;
        int nextTokenOffset = -1;
        do {
            token = this.previousToken(offset, -2);
            offset = this.getPosition();
            if (token == closingPeer && (closingPeerEnd == -2 || nextToken == closingPeerEnd)) {
                ++depth;
            } else if (headCancelToken == -2 && token == openingPeer || headCancelToken != -2 && headCancelToken != token && nextToken == openingPeer) {
                --depth;
            }
            if (depth == 0) {
                if (offset == -1) {
                    return 0;
                }
                return headCancelToken == -2 ? offset : nextTokenOffset;
            }
            nextToken = token;
            nextTokenOffset = offset;
        } while (token != -1);
        return -1;
    }

    public int findClosingPeer(int start, SQLBlockCompletionInfo blockInfo) {
        assert (start <= this.document.getLength());
        int openingPeer = blockInfo.getHeadTokenId();
        int closingPeer = blockInfo.getTailTokenId();
        int closingPeerEnd = blockInfo.getTailEndTokenId() != null ? blockInfo.getTailEndTokenId() : -2;
        int headCancelToken = blockInfo.getHeadCancelTokenId() != null ? blockInfo.getHeadCancelTokenId() : -2;
        int depth = 1;
        int prevToken = -1;
        int offset = ++start;
        while (true) {
            int token = this.nextToken(offset, this.document.getLength());
            offset = this.getPosition();
            if (token == -1) {
                return -1;
            }
            if (token == openingPeer && prevToken != headCancelToken) {
                ++depth;
            } else if (closingPeerEnd == -2 && token == closingPeer || prevToken == closingPeer && token == closingPeerEnd) {
                --depth;
            }
            if (depth == 0) {
                return offset;
            }
            prevToken = token;
        }
    }

    private class DelimiterCondition
    implements StopCondition {
        private DelimiterCondition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return this.isDelimiterChar(ch) || !Character.isWhitespace(ch);
        }

        private boolean isDelimiterChar(char ch) {
            String[] stringArray = SQLHeuristicScanner.this.syntaxManager.getStatementDelimiters();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String delim = stringArray[n2];
                if (delim.length() == 1 && delim.charAt(0) == ch) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class NonSQLIdentifierPart
    implements StopCondition {
        private NonSQLIdentifierPart() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private class NonSQLIdentifierPartDefaultPartition
    extends NonSQLIdentifierPart {
        private NonSQLIdentifierPartDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private static class NonWhitespace
    implements StopCondition {
        private NonWhitespace() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }
    }

    private class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }
}

