/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.execute;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLPragmaHandlerDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

public class SQLQueryJob
extends DataSourceJob {
    private static final Log log = Log.getLog(SQLQueryJob.class);
    public static final Object STATS_RESULTS = new Object();
    private static final int MAX_QUERY_PREVIEW_LENGTH = 8192;
    private final DBSDataContainer dataContainer;
    private final List<SQLScriptElement> queries;
    private final SQLScriptContext scriptContext;
    private final SQLResultsConsumer resultsConsumer;
    private final SQLQueryListener listener;
    private final IWorkbenchPartSite partSite;
    private DBDDataFilter dataFilter;
    private boolean connectionInvalidated = false;
    private SQLScriptCommitType commitType;
    private SQLScriptErrorHandling errorHandling;
    private boolean fetchResultSets;
    private long rsOffset;
    private long rsMaxRows;
    private DBCStatement curStatement;
    private final List<DBCResultSet> curResultSets = new ArrayList<DBCResultSet>();
    private Throwable lastError = null;
    private DBCStatistics statistics;
    private int fetchResultSetNumber;
    private int resultSetNumber;
    private SQLQuery lastGoodQuery;
    private boolean skipConfirmation;
    private int fetchSize;
    private long fetchFlags;
    private SQLQueryResult curResult;
    private transient int rowsFetched;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;

    public SQLQueryJob(@NotNull IWorkbenchPartSite partSite, @NotNull String name, @NotNull DBCExecutionContext executionContext, @Nullable DBSDataContainer dataContainer, @NotNull List<SQLScriptElement> queries, @NotNull SQLScriptContext scriptContext, @Nullable SQLResultsConsumer resultsConsumer, @Nullable SQLQueryListener listener, boolean isDisableFetchResultSet) {
        super(name, executionContext);
        this.dataContainer = dataContainer;
        this.partSite = partSite;
        this.queries = queries;
        this.scriptContext = scriptContext;
        this.resultsConsumer = resultsConsumer;
        this.listener = listener;
        DBPPreferenceStore preferenceStore = this.getDataSourceContainer().getPreferenceStore();
        this.commitType = SQLScriptCommitType.valueOf((String)preferenceStore.getString("script.commit.type"));
        this.errorHandling = SQLScriptErrorHandling.valueOf((String)preferenceStore.getString("script.error.handling"));
        this.fetchResultSets = queries.size() == 1 || preferenceStore.getBoolean("script.fetch.resultset") && !isDisableFetchResultSet;
        this.rsMaxRows = preferenceStore.getInt("resultset.maxrows");
    }

    public void setFetchResultSets(boolean fetchResultSets) {
        this.fetchResultSets = fetchResultSets;
    }

    public SQLScriptElement getLastQuery() {
        return this.queries.isEmpty() ? null : this.queries.get(0);
    }

    public SQLScriptElement getLastGoodQuery() {
        return this.lastGoodQuery;
    }

    public DBCStatement getCurrentStatement() {
        return this.curStatement;
    }

    public SQLQueryResult getCurrentQueryResult() {
        return this.curResult;
    }

    private boolean hasLimits() {
        return this.rsOffset >= 0L && this.rsMaxRows > 0L;
    }

    public void setResultSetLimit(long offset, long maxRows) {
        this.rsOffset = offset;
        this.rsMaxRows = maxRows;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setFetchFlags(long fetchFlags) {
        this.fetchFlags = fetchFlags;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(DBRProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleTransactionStatements(@NotNull DBCTransactionManager txnManager, @NotNull DBCSession session, @NotNull SQLQuery query) throws DBCException {
        if (query.getType().equals((Object)SQLQueryType.COMMIT)) {
            txnManager.commit(session);
        } else if (query.getType().equals((Object)SQLQueryType.ROLLBACK)) {
            txnManager.rollback(session, null);
        }
    }

    private boolean executeSingleQuery(@NotNull DBCSession session, @NotNull SQLScriptElement element, boolean fireEvents) {
        SQLQuery originalQuery;
        block41: {
            if (!this.scriptContext.getPragmas().isEmpty() && element instanceof SQLQuery) {
                SQLQueryDataContainer container = new SQLQueryDataContainer(() -> ((SQLQueryJob)this).getExecutionContext(), (SQLQuery)element, this.scriptContext, log);
                Iterator it = this.scriptContext.getPragmas().entrySet().iterator();
                while (it.hasNext()) {
                    int result;
                    Map.Entry entry = it.next();
                    String id = (String)entry.getKey();
                    SQLPragmaHandlerDescriptor descriptor = SQLCommandsRegistry.getInstance().getPragmaHandler(id);
                    if (descriptor == null) continue;
                    try {
                        result = descriptor.createHandler().processPragma(session.getProgressMonitor(), (DBSDataContainer)container, (Map)entry.getValue());
                    }
                    catch (DBException e) {
                        this.lastError = e;
                        return false;
                    }
                    if (CommonUtils.isBitSet((int)result, (int)1)) {
                        it.remove();
                    }
                    if (!CommonUtils.isBitSet((int)result, (int)2)) continue;
                    return false;
                }
            }
            if (element instanceof SQLControlCommand) {
                try {
                    boolean it = this.scriptContext.executeControlCommand((SQLControlCommand)element);
                    return it;
                }
                catch (Throwable e) {
                    if (!(e instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL command", e);
                    }
                    this.lastError = e;
                    return false;
                }
                finally {
                    this.statistics.addStatementsCount();
                    this.statistics.addMessage("Command " + ((SQLControlCommand)element).getCommand() + " processed");
                }
            }
            SQLQuery sqlQuery = (SQLQuery)element;
            this.lastError = null;
            if (!this.skipConfirmation && this.getDataSourceContainer().getConnectionConfiguration().getConnectionType().isConfirmExecute() && !SQLSemanticProcessor.isSelectQuery((SQLDialect)session.getDataSource().getSQLDialect(), (String)element.getText())) {
                int confirmResult = this.confirmQueryExecution((SQLQuery)element, this.queries.size() > 1);
                switch (confirmResult) {
                    case 3: {
                        return true;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.skipConfirmation = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            DBCExecutionContext executionContext = this.getExecutionContext();
            DBPDataSource dataSource = executionContext.getDataSource();
            originalQuery = sqlQuery;
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.beginTask("Get data receiver", 1);
            monitor.subTask("Create results view");
            if (!this.scriptContext.fillQueryParameters(originalQuery, () -> this.resultsConsumer.getDataReceiver(originalQuery, this.resultSetNumber), CommonUtils.isBitSet((long)this.fetchFlags, (long)256L))) {
                return false;
            }
            monitor.done();
            long startTime = System.currentTimeMillis();
            boolean startQueryAlerted = false;
            String queryText = originalQuery.getText();
            if (this.dataFilter != null && this.dataFilter.hasFilters()) {
                String filteredQueryText = dataSource.getSQLDialect().addFiltersToQuery(session.getProgressMonitor(), dataSource, queryText, this.dataFilter);
                sqlQuery = new SQLQuery(executionContext.getDataSource(), filteredQueryText, sqlQuery);
            } else {
                sqlQuery = new SQLQuery(executionContext.getDataSource(), queryText, sqlQuery);
            }
            this.curResult = new SQLQueryResult(sqlQuery);
            if (this.rsOffset > 0L) {
                this.curResult.setRowOffset(Long.valueOf(this.rsOffset));
            }
            monitor.beginTask("Process query", 1);
            monitor.subTask("Initialize context");
            try {
                try {
                    this.closeStatement();
                    if (!this.connectionInvalidated && dataSource.getContainer().getPreferenceStore().getBoolean("statement.invalidate.before.execute")) {
                        executionContext.invalidateContext(monitor);
                        this.connectionInvalidated = true;
                    }
                    this.statistics.setQueryText(sqlQuery.getText());
                    if (fireEvents && this.listener != null) {
                        try {
                            this.listener.onStartQuery(session, sqlQuery);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        startQueryAlerted = true;
                    }
                    monitor.subTask("Execute query");
                    startTime = System.currentTimeMillis();
                    SQLQuery execStatement = sqlQuery;
                    DBRRunnableParametrized executor = param -> {
                        boolean changedToManualCommit = false;
                        try {
                            if (this.resultsConsumer instanceof ISmartTransactionManager && ((ISmartTransactionManager)this.resultsConsumer).isSmartAutoCommit()) {
                                changedToManualCommit = DBExecUtils.checkSmartAutoCommit((DBCSession)session, (String)execStatement.getText());
                            }
                            long execStartTime = System.currentTimeMillis();
                            this.executeStatement(session, execStatement, execStartTime, this.curResult);
                        }
                        catch (Throwable e) {
                            if (changedToManualCommit) {
                                try {
                                    DBCTransactionManager transactionManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                                    if (transactionManager != null) {
                                        transactionManager.setAutoCommit(monitor, true);
                                    }
                                }
                                catch (DBCException dBCException) {
                                    log.warn((Object)"Error returning to auto commit");
                                }
                            }
                            throw new InvocationTargetException(e);
                        }
                    };
                    if (this.shouldRecoverQuery(execStatement)) {
                        DBExecUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), (DBRRunnableParametrized)executor);
                    } else {
                        try {
                            executor.run((Object)session);
                        }
                        catch (InvocationTargetException e) {
                            throw e.getTargetException();
                        }
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                    if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && this.commitType != SQLScriptCommitType.AUTOCOMMIT) {
                        this.handleTransactionStatements(txnManager, session, sqlQuery);
                    }
                }
                catch (Throwable ex) {
                    if (!(ex instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL", ex);
                    }
                    this.curResult.setError(ex);
                    this.lastError = ex;
                    this.curResult.setQueryTime(System.currentTimeMillis() - startTime);
                    if (fireEvents && this.listener != null && startQueryAlerted) {
                        this.notifyQueryExecutionEnd(this.curResult);
                    }
                    monitor.done();
                    break block41;
                }
            }
            catch (Throwable throwable) {
                this.curResult.setQueryTime(System.currentTimeMillis() - startTime);
                if (fireEvents && this.listener != null && startQueryAlerted) {
                    this.notifyQueryExecutionEnd(this.curResult);
                }
                monitor.done();
                throw throwable;
            }
            this.curResult.setQueryTime(System.currentTimeMillis() - startTime);
            if (fireEvents && this.listener != null && startQueryAlerted) {
                this.notifyQueryExecutionEnd(this.curResult);
            }
            monitor.done();
        }
        if (this.curResult.getError() != null && this.errorHandling != SQLScriptErrorHandling.IGNORE) {
            return false;
        }
        this.lastGoodQuery = originalQuery;
        return true;
    }

    private boolean shouldRecoverQuery(SQLQuery query) {
        Statement statement = query.getStatement();
        return !(statement instanceof Insert) && !(statement instanceof Delete) && !(statement instanceof Update) && (!(statement instanceof Select) || !(((Select)statement).getSelectBody() instanceof PlainSelect) || CommonUtils.isEmpty((Collection)((PlainSelect)((Select)statement).getSelectBody()).getIntoTables()));
    }

    public void notifyQueryExecutionEnd(SQLQueryResult curResult) {
        try {
            this.listener.onEndQuery(null, curResult, this.statistics);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void executeStatement(@NotNull DBCSession session, SQLQuery sqlQuery, long startTime, SQLQueryResult curResult) throws DBCException {
        AbstractExecutionSource source = new AbstractExecutionSource(this.dataContainer, session.getExecutionContext(), (Object)this.partSite.getPart(), (Object)sqlQuery);
        source.setScriptContext((DBCScriptContext)this.scriptContext);
        DBCStatement dbcStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)this.rsOffset, (long)this.rsMaxRows);
        DBExecUtils.setStatementFetchSize((DBCStatement)dbcStatement, (long)this.rsOffset, (long)this.rsMaxRows, (int)this.fetchSize);
        this.curStatement = dbcStatement;
        int statementTimeout = this.getDataSourceContainer().getPreferenceStore().getInt("statement.timeout");
        if (statementTimeout > 0) {
            try {
                dbcStatement.setStatementTimeout(statementTimeout);
            }
            catch (Throwable e) {
                log.debug((Object)("Can't set statement timeout:" + e.getMessage()));
            }
        }
        try {
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.subTask("Execute query");
            boolean hasResultSet = dbcStatement.executeStatement();
            this.statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            this.statistics.addStatementsCount();
            curResult.setHasResultSet(hasResultSet);
            long updateCount = -1L;
            int resultSetCounter = 0;
            boolean confirmed = false;
            while (true) {
                if (this.fetchResultSetNumber < 0 || this.fetchResultSetNumber == this.resultSetNumber) {
                    if (hasResultSet && !confirmed && resultSetCounter >= this.getDataSourceContainer().getPreferenceStore().getInt("SQLEditor.resultSet.queryTabLimit")) {
                        confirmed = hasResultSet = DBWorkbench.getPlatformUI().confirmAction(SQLEditorMessages.editors_sql_warning_many_subtables_title, NLS.bind((String)SQLEditorMessages.editors_sql_warning_many_subtables_text, (Object)this.getDataSourceContainer().getPreferenceStore().getInt("SQLEditor.resultSet.queryTabLimit")), true);
                    }
                    if (hasResultSet && this.fetchResultSets) {
                        DBCResultSet resultSet;
                        try {
                            resultSet = dbcStatement.openResultSet();
                            ++resultSetCounter;
                        }
                        catch (DBCException e) {
                            DBPErrorAssistant.ErrorType errorType = DBExecUtils.discoverErrorType((DBPDataSource)session.getDataSource(), (Throwable)e);
                            if (errorType == DBPErrorAssistant.ErrorType.RESULT_SET_MISSING && dbcStatement.nextResults()) continue;
                            throw e;
                        }
                        if (resultSet == null) {
                            break;
                        }
                        DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(sqlQuery, this.resultSetNumber);
                        if (dataReceiver != null) {
                            try {
                                hasResultSet = this.fetchQueryData(session, resultSet, curResult, curResult.addExecuteResult(true), dataReceiver, true);
                            }
                            catch (DBCException e) {
                                if (this.rowsFetched == 0) {
                                    throw e;
                                }
                                log.warn((Object)"Fetch failed", (Throwable)e);
                                this.statistics.setRowsFetched((long)this.rowsFetched);
                                this.statistics.setError((Throwable)e);
                            }
                        }
                    }
                }
                if (!hasResultSet) {
                    try {
                        updateCount = dbcStatement.getUpdateRowCount();
                        SQLQueryResult.ExecuteResult executeResult = curResult.addExecuteResult(false);
                        if (updateCount >= 0L) {
                            executeResult.setUpdateCount(Long.valueOf(updateCount));
                            this.statistics.addRowsUpdated(updateCount);
                        }
                    }
                    catch (DBCException e) {
                        log.warn((Object)"Can't obtain update count", (Throwable)e);
                    }
                }
                if (hasResultSet && this.fetchResultSets) {
                    this.fetchResultSetNumber = ++this.resultSetNumber;
                }
                if (!hasResultSet && updateCount < 0L) {
                    break;
                }
                if (!session.getDataSource().getInfo().supportsMultipleResults()) break;
                try {
                    hasResultSet = dbcStatement.nextResults();
                }
                catch (DBCException e) {
                    if (session.getDataSource().getInfo().isMultipleResultsFetchBroken()) {
                        this.statistics.addWarning((Throwable)e);
                        this.statistics.setError((Throwable)e);
                        hasResultSet = dbcStatement.nextResults();
                    }
                    throw e;
                }
                updateCount = hasResultSet ? -1 : 0;
            }
        }
        finally {
            try {
                curResult.addWarnings(dbcStatement.getStatementWarnings());
            }
            catch (Throwable e) {
                log.warn((Object)"Can't read execution warnings", e);
            }
            if (!CommonUtils.isEmpty((Collection)this.statistics.getWarnings())) {
                curResult.addWarnings(this.statistics.getWarnings().toArray(new Throwable[0]));
            }
            if (!this.keepStatementOpen()) {
                this.closeStatement();
            }
        }
    }

    private void showExecutionResult(DBCSession session) {
        if (this.isShowExecutionResult()) {
            SQLQuery query = new SQLQuery(session.getDataSource(), "", -1, -1);
            if (this.queries.size() == 1) {
                query.setText(this.queries.get(0).getText());
            }
            query.setData(STATS_RESULTS);
            DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(query, this.resultSetNumber);
            if (dataReceiver != null && !(dataReceiver instanceof IDataTransferConsumer)) {
                try {
                    this.fetchExecutionResult(session, dataReceiver, query);
                }
                catch (DBCException e) {
                    log.error((Object)"Error generating execution result stats", (Throwable)e);
                }
            }
        }
    }

    private boolean isShowExecutionResult() {
        DBPPreferenceStore store = this.getDataSourceContainer().getPreferenceStore();
        SQLPreferenceConstants.StatisticsTabOnExecutionBehavior statisticsTabOnExecutionBehavior = SQLPreferenceConstants.StatisticsTabOnExecutionBehavior.getByName(store.getString("SQLEditor.showStatisticsForQueriesWithResults"));
        switch (statisticsTabOnExecutionBehavior) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return this.resultSetNumber <= 0 || this.statistics.getRowsFetched() <= 0L;
            }
            case FOR_MULTIPLE_QUERIES: {
                if (this.resultSetNumber <= 0 || this.statistics.getRowsUpdated() >= 0L) {
                    return true;
                }
                return this.statistics.getStatementsCount() > 1;
            }
        }
        return false;
    }

    private void fetchExecutionResult(@NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @NotNull SQLQuery query) throws DBCException {
        StatResultSet fakeResultSet = new StatResultSet(session, this.curStatement);
        SQLQueryResult resultInfo = new SQLQueryResult(query);
        SQLQueryResult.ExecuteResult executeResult = resultInfo.addExecuteResult(true);
        if (this.statistics.getStatementsCount() > 1) {
            fakeResultSet.addColumn("Queries", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Execute time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Fetch time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Total time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Start time", DBPDataKind.DATETIME);
            fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
            fakeResultSet.addRow(new Object[]{this.statistics.getStatementsCount(), this.statistics.getRowsUpdated() < 0L ? 0L : this.statistics.getRowsUpdated(), this.statistics.getExecuteTime(), this.statistics.getFetchTime(), this.statistics.getTotalTime(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.statistics.getStartTime())), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())});
            executeResult.setResultSetName(SQLEditorMessages.editors_sql_statistics);
        } else {
            long updateCount = this.statistics.getRowsUpdated();
            fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Query", DBPDataKind.STRING);
            fakeResultSet.addColumn("Start time", DBPDataKind.DATETIME);
            fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
            fakeResultSet.addRow(new Object[]{updateCount, query.getText(), new Date(this.statistics.getStartTime()), new Date()});
            executeResult.setResultSetName(SQLEditorMessages.editors_sql_data_grid);
        }
        this.fetchQueryData(session, (DBCResultSet)fakeResultSet, resultInfo, executeResult, dataReceiver, false);
    }

    private boolean fetchQueryData(DBCSession session, DBCResultSet resultSet, SQLQueryResult result, SQLQueryResult.ExecuteResult executeResult, DBDDataReceiver dataReceiver, boolean updateStatistics) throws DBCException {
        if (dataReceiver == null) {
            return false;
        }
        if (resultSet == null) {
            return false;
        }
        boolean keepCursor = this.keepStatementOpen();
        if (keepCursor) {
            this.curResultSets.add(resultSet);
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Fetch result set");
        DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
        dataReceiver.fetchStart(session, resultSet, this.rsOffset, this.rsMaxRows);
        try {
            Object sourceName = null;
            if (result != null) {
                String queryTitle = result.getStatement().getQueryTitle();
                if (!CommonUtils.isEmpty((String)queryTitle)) {
                    sourceName = queryTitle;
                } else {
                    DBCResultSetMetaData rsMeta = resultSet.getMeta();
                    for (DBCAttributeMetaData attr : rsMeta.getAttributes()) {
                        String entityName = attr.getEntityName();
                        if (CommonUtils.isEmpty((String)entityName)) continue;
                        if (sourceName == null) {
                            sourceName = entityName;
                            continue;
                        }
                        if (((String)sourceName).equals(entityName)) continue;
                        sourceName = (String)sourceName + "(+)";
                        break;
                    }
                    if (CommonUtils.isEmpty((String)sourceName)) {
                        try {
                            sourceName = resultSet.getResultSetName();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (CommonUtils.isEmpty((String)sourceName)) {
                    sourceName = SQLEditorMessages.editors_sql_data_grid;
                }
                executeResult.setResultSetName((String)sourceName);
            }
            long fetchStartTime = System.currentTimeMillis();
            this.rowsFetched = 0;
            while (!(this.hasLimits() && fetchProgress.isMaxRowsFetched(this.rsMaxRows) || fetchProgress.isCanceled() || !resultSet.nextRow())) {
                dataReceiver.fetchRow(session, resultSet);
                ++this.rowsFetched;
                fetchProgress.monitorRowFetch();
            }
            if (updateStatistics) {
                this.statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
            }
        }
        finally {
            if (!keepCursor) {
                try {
                    resultSet.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Error while closing resultset", e);
                }
            }
            try {
                dataReceiver.fetchEnd(session, resultSet);
            }
            catch (Throwable e) {
                log.error((Object)"Error while handling end of result set fetch", e);
            }
            dataReceiver.close();
        }
        if (result != null) {
            executeResult.setRowCount(Long.valueOf(fetchProgress.getRowCount()));
        }
        if (updateStatistics) {
            this.statistics.setRowsFetched(fetchProgress.getRowCount());
        }
        monitor.subTask(fetchProgress.getRowCount() + " rows fetched");
        return true;
    }

    private boolean keepStatementOpen() {
        return this.queries.size() == 1 && this.getDataSourceContainer().getPreferenceStore().getBoolean("keep.statement.open");
    }

    private void closeStatement() {
        if (this.curStatement != null) {
            try {
                for (DBCResultSet resultSet : this.curResultSets) {
                    resultSet.close();
                }
            }
            finally {
                block15: {
                    this.curResultSets.clear();
                    try {
                        try {
                            this.curStatement.close();
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error closing statement", e);
                            this.curStatement = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.curStatement = null;
                        throw throwable;
                    }
                    this.curStatement = null;
                }
            }
        }
    }

    public void extractData(@NotNull DBCSession session, @NotNull SQLScriptElement query, int resultNumber, boolean fireEvents) throws DBCException {
        query.reset();
        this.statistics = new DBCStatistics();
        this.resultSetNumber = resultNumber;
        session.getProgressMonitor().subTask(CommonUtils.truncateString((String)query.getText(), (int)512));
        boolean result = this.executeSingleQuery(session, query, fireEvents);
        if (!result && this.lastError != null) {
            if (this.lastError instanceof DBCException) {
                throw (DBCException)this.lastError;
            }
            throw new DBCException(this.lastError, this.getExecutionContext());
        }
        if (result && this.statistics.getStatementsCount() > 0) {
            this.showExecutionResult(session);
        }
    }

    public void setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setFetchResultSetNumber(int fetchResultSetNumber) {
        this.fetchResultSetNumber = fetchResultSetNumber;
    }

    public boolean isJobOpen() {
        return this.curStatement != null;
    }

    public void closeJob() {
        this.closeStatement();
    }

    private int confirmQueryExecution(final @NotNull SQLQuery query, final boolean scriptMode) {
        final DBPConnectionType connectionType = this.getDataSourceContainer().getConnectionConfiguration().getConnectionType();
        return (Integer)new UITask<Integer>(){

            protected Integer runTask() {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(UIUtils.getActiveWorkbenchShell(), "Confirm query execution", null, "You are in '" + connectionType.getName() + "' connection.\nDo you confirm query execution?", 4, ConfirmationDialog.getButtonLabels((int)6), 0, "Do not ask for " + connectionType.getName() + " connections", false){

                    protected boolean isResizable() {
                        return true;
                    }

                    protected IDialogSettings getDialogBoundsSettings() {
                        return UIUtils.getDialogSettings((String)"DBeaver.SQLQueryConfirmDialog");
                    }

                    protected void createDialogAndButtonArea(Composite parent) {
                        this.dialogArea = this.createDialogArea(parent);
                        if (this.dialogArea.getLayoutData() instanceof GridData) {
                            ((GridData)this.dialogArea.getLayoutData()).grabExcessVerticalSpace = false;
                        }
                        Text messageText = new Text(parent, 2634);
                        Object text = query.getText();
                        if (((String)text).length() > 8192) {
                            text = CommonUtils.truncateString((String)text, (int)8192) + "... (truncated " + (((String)text).length() - 8192) + " characters)";
                        }
                        messageText.setText((String)text);
                        GridData gd = new GridData(1808);
                        gd.heightHint = UIUtils.getFontHeight((Control)messageText) * 4 + 10;
                        gd.horizontalSpan = 2;
                        messageText.setLayoutData((Object)gd);
                        this.buttonBar = this.createButtonBar(parent);
                        1.applyDialogFont((Control)parent);
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
                        if (scriptMode) {
                            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                        }
                    }
                };
                int result = dialog.open();
                if (dialog.getToggleState()) {
                    connectionType.setConfirmExecute(false);
                    DBWorkbench.getPlatform().getDataSourceProviderRegistry().saveConnectionTypes();
                }
                return result;
            }
        }.execute();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;
        }
        int[] nArray = new int[DBPPlatformUI.UserResponse.values().length];
        try {
            nArray[DBPPlatformUI.UserResponse.CANCEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.RETRY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.STOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse = nArray;
        return nArray;
    }
}

