/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.BaseSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class ViewSQLDialog
extends BaseSQLDialog {
    private static final String DIALOG_ID = "DBeaver.ViewSQLDialog";
    private DBPContextProvider contextProvider;
    private String text;
    private boolean showSaveButton = false;
    private boolean enlargeViewPanel = true;
    private boolean wordWrap = false;
    private boolean showOpenEditorButton;

    public ViewSQLDialog(IWorkbenchPartSite parentSite, @Nullable DBPContextProvider contextProvider, String title, @Nullable DBPImage image, String text) {
        super(parentSite, title, image);
        this.contextProvider = contextProvider;
        this.text = text;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public void setShowSaveButton(boolean showSaveButton) {
        this.showSaveButton = showSaveButton;
    }

    public void setEnlargeViewPanel(boolean enlargeViewPanel) {
        this.enlargeViewPanel = enlargeViewPanel;
    }

    public void setShowOpenEditorButton(boolean showOpenEditorButton) {
        this.showOpenEditorButton = showOpenEditorButton;
    }

    @Override
    protected boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Button closeButton = this.getButton(this.showSaveButton ? 10 : 0);
        if (closeButton != null) {
            UIUtils.asyncExec(() -> ((Button)closeButton).setFocus());
        }
        return contents;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite sqlPanel = this.createSQLPanel(composite);
        GridData gd = (GridData)sqlPanel.getLayoutData();
        if (this.enlargeViewPanel) {
            gd.widthHint = 500;
            gd.heightHint = 400;
        } else {
            gd.widthHint = 400;
            gd.heightHint = 100;
        }
        return sqlPanel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showOpenEditorButton) {
            this.createButton(parent, 11, ResultSetMessages.dialog_text_view_open_editor, true);
        }
        if (this.showSaveButton) {
            this.createButton(parent, 10, SQLEditorMessages.dialog_view_sql_button_persist, true);
            this.createCopyButton(parent);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else if (this.isReadOnly()) {
            this.createCopyButton(parent);
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    @Override
    protected String getSQLText() {
        return this.text;
    }

    public void setSQLText(String text) {
        this.text = text;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 11) {
            String title = this.getTitle();
            String text = this.getText();
            UIUtils.asyncExec(() -> SQLEditorHandlerOpenEditor.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), new SQLNavigatorContext(this.contextProvider.getExecutionContext()), title, text));
            this.close();
        } else if (buttonId == 10) {
            this.setReturnCode(10);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    @Override
    protected DBCExecutionContext getExecutionContext() {
        return this.contextProvider.getExecutionContext();
    }
}

