/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.awt.Desktop;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class OpenLinkInWindowHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String TITLE = "Search selection in web";
    private static final String SEARCH_WEB_ADDRESS_PREFIX = "https://www.google.com/search?q=";

    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        void textSelection;
        block7: {
            block6: {
                SQLEditor editor = (SQLEditor)((Object)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class));
                if (editor == null) {
                    DBWorkbench.getPlatformUI().showError(TITLE, "No suitable editor was found for SQL");
                    return null;
                }
                ISelection selection = editor.getSelectionProvider().getSelection();
                ISelection iSelection = selection;
                if (!(iSelection instanceof TextSelection)) break block6;
                TextSelection textSelection2 = (TextSelection)iSelection;
                TextSelection cfr_ignored_0 = (TextSelection)iSelection;
                if (!this.isSelectedTextNullOrEmpty(selection)) break block7;
            }
            DBWorkbench.getPlatformUI().showError(TITLE, "No text was selected");
            return null;
        }
        String googleLink = textSelection.getText().trim();
        googleLink = URLEncoder.encode(googleLink, StandardCharsets.UTF_8);
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            ShellUtils.launchProgram((String)(SEARCH_WEB_ADDRESS_PREFIX + googleLink));
        } else {
            DBWorkbench.getPlatformUI().showError(TITLE, "Desktop is not supported.");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSelectedTextNullOrEmpty(ISelection selection) {
        void textSelection;
        ISelection iSelection;
        if (selection == null || selection.isEmpty() || !((iSelection = selection) instanceof TextSelection)) {
            return true;
        }
        TextSelection textSelection2 = (TextSelection)iSelection;
        TextSelection cfr_ignored_0 = (TextSelection)iSelection;
        return CommonUtils.isEmpty((String)textSelection.getText());
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setText(SQLEditorMessages.editors_sql_actions_search_selected_text_online);
        element.setTooltip(SQLEditorMessages.editors_sql_actions_search_selected_text_online_tip);
    }
}

