/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;

public class SQLEditorSourceViewer
extends ProjectionViewer {
    private final LinkedList<VerifyKeyListener> verifyKeyListeners = new LinkedList();
    private final Supplier<DBPPreferenceStore> currentPrefStoreSupplier;

    public SQLEditorSourceViewer(@NotNull Composite parent, @Nullable IVerticalRuler ruler, @Nullable IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, @NotNull Supplier<DBPPreferenceStore> currentPrefStoreSupplier) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.currentPrefStoreSupplier = currentPrefStoreSupplier;
    }

    void refreshTextSelection() {
        ITextSelection selection = (ITextSelection)this.getSelection();
        this.fireSelectionChanged(selection.getOffset(), selection.getLength());
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        StyledText textWidget = super.createTextWidget(parent, styles);
        textWidget.addListener(3005, event -> {
            switch (event.type) {
                case 3005: {
                    if (event.character != '\t' || !this.currentPrefStoreSupplier.get().getBoolean("SQLEditor.ContentAssistant.autocompletion.tab")) break;
                    VerifyEvent verifyEvent = new VerifyEvent(event);
                    verifyEvent.character = (char)10;
                    for (VerifyKeyListener listener : List.copyOf(this.verifyKeyListeners)) {
                        listener.verifyKey(verifyEvent);
                    }
                    event.doit = verifyEvent.doit;
                }
            }
        });
        return textWidget;
    }

    /*
     * WARNING - void declaration
     */
    private boolean expandAnnotationsContaining(@NotNull ProjectionAnnotationModel projectionAnnotationModel, int offset) {
        Iterator it = projectionAnnotationModel.getAnnotationIterator(offset, 0, true, true);
        boolean expanded = false;
        while (it.hasNext()) {
            Position position;
            void p;
            Annotation annotation = (Annotation)it.next();
            Annotation annotation2 = annotation;
            if (!(annotation2 instanceof ProjectionAnnotation)) continue;
            ProjectionAnnotation cfr_ignored_0 = (ProjectionAnnotation)annotation2;
            ProjectionAnnotation cfr_ignored_1 = (ProjectionAnnotation)annotation2;
            if (!p.isCollapsed() || (position = projectionAnnotationModel.getPosition(annotation)) == null || !position.includes(offset)) continue;
            expanded = true;
            projectionAnnotationModel.expand(annotation);
        }
        return expanded;
    }

    public boolean exposeModelRange(@NotNull IRegion modelRange) {
        if (this.isProjectionMode()) {
            boolean b;
            ProjectionAnnotationModel projectionAnnotationModel = this.getProjectionAnnotationModel();
            boolean a = this.expandAnnotationsContaining(projectionAnnotationModel, modelRange.getOffset());
            boolean expanded = a | (b = this.expandAnnotationsContaining(projectionAnnotationModel, modelRange.getOffset() + modelRange.getLength()));
            if (expanded) {
                projectionAnnotationModel.modifyAnnotations(null, null, null);
            }
            return expanded;
        }
        if (!this.overlapsWithVisibleRegion(modelRange.getOffset(), modelRange.getLength())) {
            this.resetVisibleRegion();
            return true;
        }
        return false;
    }

    public void setHyperlinkPresenter(IHyperlinkPresenter hyperlinkPresenter) throws IllegalStateException {
        if (this.fHyperlinkManager != null) {
            this.fHyperlinkManager.uninstall();
            this.fHyperlinkManager = null;
        }
        super.setHyperlinkPresenter(hyperlinkPresenter);
    }

    public void prependVerifyKeyListener(VerifyKeyListener listener) {
        this.verifyKeyListeners.addFirst(listener);
        super.prependVerifyKeyListener(listener);
    }

    public void appendVerifyKeyListener(VerifyKeyListener listener) {
        this.verifyKeyListeners.addLast(listener);
        super.appendVerifyKeyListener(listener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener listener) {
        this.verifyKeyListeners.remove(listener);
        super.removeVerifyKeyListener(listener);
    }
}

