/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;

class SQLContentFormatter
extends ContentFormatter
implements IContentFormatterExtension {
    private SQLEditorBase editor;

    SQLContentFormatter(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void format(IDocument document, IFormattingContext context) {
        IFormattingStrategy strategy;
        if (!this.editor.getActivePreferenceStore().getBoolean("SQLEditor.format.activeQuery")) {
            IRegion region = (IRegion)context.getProperty((Object)"formatting.context.region");
            if (region == null) {
                region = new Region(0, this.editor.getDocument().getLength());
            }
            if (region != null) {
                super.format(document, region);
                return;
            }
        }
        if ((strategy = this.getFormattingStrategy("__dftl_partition_content_type")) != null) {
            SQLScriptElement activeQuery = this.editor.extractActiveQuery();
            if (activeQuery == null) {
                return;
            }
            super.format(document, (IRegion)new Region(activeQuery.getOffset(), activeQuery.getLength()));
        }
    }
}

