/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class StatementStatusParcel
extends Parcel {
    public static final byte SUCCESS = 0;
    public static final byte ERROR = 1;
    public static final byte FAILURE = 2;
    public static final byte STMTERR = 3;
    public static final byte FIELD_MODE = 1;
    public static final byte RECORD_MODE = 2;
    public static final byte INDICATOR_MODE = 3;
    public static final byte MULTIPART_INDIC_MODE = 4;
    public static final int EXT_WARNING = 1;
    public static final int EXT_ERROR_FAILURE = 2;
    public static final int EXT_CASCADING_ERROR = 3;
    public static final int EXT_SYNTAX_LOCATION = 4;
    public static final int EXT_MIN_RESPONSE_BUFFER_SIZE = 5;
    public static final int EXT_RETRYABLE_ERROR = 6;
    public static final int EXT_DATA_RELATED_ERROR = 7;
    public static final int EXT_SQLSTATE = 8;
    public static final int EXT_COMPLEX_ERROR_COUNT = 9;
    public static final int EXT_MERGE_COUNT = 10;
    public static final int EXT_PPI_COUNT = 11;
    public static final int EXT_TRIGGER_COUNT = 12;
    public static final int EXT_MULTILOAD_COUNT = 13;
    public static final int EXT_ACTIVITY_DESCRIPTION = 14;
    public static final int EXT_COMPLEX_ERROR_DESCRIPTION = 15;
    public static final int EXT_MERGE_DESCRIPTION = 16;
    public static final int EXT_PPI_DESCRIPTION = 17;
    public static final int EXT_TRIGGER_DESCRIPTION = 18;
    public static final int EXT_RI_COUNT = 19;
    public static final int EXT_RI_DESCRIPTION = 20;
    public static final int EXT_TABLE_COPY_COUNT = 21;
    public static final int EXT_TABLE_COPY_DESCRIPTION = 22;
    public static final int EXT_AUTO_COMMIT = 23;
    public static final int EXT_TRANSACTION_STATUS = 24;
    public static final int EXT_STORED_PROCEDURE_COUNT = 25;
    public static final int EXT_STORED_PROCEDURE_DESCRIPTION = 26;
    private static final int EXT_HEADER_LENGTH = 6;
    protected byte m_nStatementStatus;
    private byte m_byResponseMode;
    protected int m_nStatementNumber;
    protected short m_nCode;
    protected short m_nActivityType;
    protected long m_nActivityCount;
    protected int m_nFieldCount;
    protected short m_nLastWarningCode;
    protected short m_nComponentID;
    protected SQLWarning m_sqlWarningChain;
    protected SQLException m_sqlExceptionChain;

    protected StatementStatusParcel(GenericTeradataConnection genericTeradataConnection) {
        super(genericTeradataConnection);
    }

    public StatementStatusParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.initResponseParcel(tDPacketStream);
        int n = tDPacketStream.position();
        this.m_nStatementStatus = tDPacketStream.get();
        this.m_byResponseMode = tDPacketStream.get();
        tDPacketStream.position(tDPacketStream.position() + 2);
        this.m_nStatementNumber = tDPacketStream.getInt();
        this.m_nCode = tDPacketStream.getShort();
        this.m_nActivityType = tDPacketStream.getShort();
        this.m_nActivityCount = tDPacketStream.getLong();
        if ((this.m_nActivityCount < 0L || this.m_nActivityCount > Integer.MAX_VALUE) && ActivityAnalyzer.update(this.m_nActivityType)) {
            BigInteger bigInteger = new BigInteger(Long.toHexString(this.m_nActivityCount), 16);
            this.addWarning(ErrorFactory.makeSQLWarning("TJ781", String.valueOf(this.m_nStatementNumber), String.valueOf(bigInteger)));
        }
        this.m_nFieldCount = tDPacketStream.getInt();
        tDPacketStream.position(tDPacketStream.position() + 4);
        while (tDPacketStream.position() - n + 6 <= this.bodyLength()) {
            short s = tDPacketStream.getShort();
            int n2 = tDPacketStream.getInt();
            int n3 = tDPacketStream.position();
            switch (s) {
                case 1: {
                    this.initWarning(tDPacketStream);
                }
            }
            tDPacketStream.position(n3 + n2);
        }
    }

    private void initWarning(TDPacketStream tDPacketStream) throws SQLException {
        this.m_nLastWarningCode = tDPacketStream.getShort();
        this.m_nComponentID = tDPacketStream.getShort();
        int n = tDPacketStream.getInt();
        String string = n > 0 ? tDPacketStream.getString(n, this.m_con) : null;
        this.analyzeWarning(this.m_nLastWarningCode, string);
        if (this.log.canLog(1)) {
            this.log.info("StatementStatus.initWarning: WarningCode=" + this.m_nLastWarningCode + " ComponentID=" + this.m_nComponentID + " Message=" + string);
        }
    }

    protected void analyzeWarning(short s, String string) {
        if (ErrorAnalyzer.warningIsReallyError(s)) {
            this.addException(ErrorFactory.makeDatabaseSQLException(string, s));
        } else {
            this.addWarning(ErrorFactory.makeDatabaseSQLWarning(string, s));
        }
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.m_sqlWarningChain != null) {
            this.m_sqlWarningChain.setNextWarning(sQLWarning);
        } else {
            this.m_sqlWarningChain = sQLWarning;
        }
    }

    public void addException(SQLException sQLException) {
        if (this.m_sqlExceptionChain != null) {
            this.m_sqlExceptionChain.setNextException(sQLException);
        } else {
            this.m_sqlExceptionChain = sQLException;
        }
    }

    public void verifySuccess() throws SQLException {
        if (this.m_nStatementStatus != 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ780", this.m_nStatementNumber, this.m_nStatementStatus);
        }
    }

    public int getStatementNumber() {
        return this.m_nStatementNumber;
    }

    public short getCode() {
        return this.m_nCode;
    }

    public short getActivityType() {
        return this.m_nActivityType;
    }

    public long getActivityCount() {
        return this.m_nActivityCount;
    }

    public int getFieldCount() {
        return this.m_nFieldCount;
    }

    public short getLastWarningCode() {
        return this.m_nLastWarningCode;
    }

    public short getInfo() {
        return this.m_nComponentID;
    }

    public SQLWarning getSQLWarnings() {
        return this.m_sqlWarningChain;
    }

    public SQLException getExceptions() {
        return this.m_sqlExceptionChain;
    }

    public boolean hasWarningCode(int n) {
        for (SQLWarning sQLWarning = this.m_sqlWarningChain; sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            if (sQLWarning.getErrorCode() != n) continue;
            return true;
        }
        return false;
    }
}

