/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc.raw.RawResultSetMetaData;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class RawResultSet
implements ResultSet,
BufferContainer {
    private RawPreparedStatement pstmt = null;
    private byte[] rawMessageReceived = new byte[52];
    private int rowNumber = 0;
    private int rowCount = 1;

    public RawResultSet(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    @Override
    public byte[] getBuffer() {
        return this.rawMessageReceived;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.rawMessageReceived = byArray;
    }

    protected void abortIfClosed() throws SQLException {
        this.pstmt.abortIfClosed();
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ598");
        }
    }

    private void receiveResults() throws SQLException {
        TDNetworkIOIF tDNetworkIOIF = ((RawConnection)this.pstmt.getConnection()).getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDNetworkIOIF.read(this, this.pstmt.getQueryTimeout() * 1000, null, true);
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public void afterLast() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.rawMessageReceived = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.abortIfClosed();
        if (string.equals("RawMessage")) {
            return 1;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ602", string);
    }

    @Override
    public boolean first() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public byte getByte(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.abortIfClosed();
        ((RawResultSetMetaData)this.pstmt.getMetaData()).abortIfIndexNotValid(n);
        return this.rawMessageReceived;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Date getDate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public double getDouble(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public float getFloat(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getInt(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public long getLong(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.pstmt.getMetaData();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Object getObject(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getRow() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber > this.rowCount ? 0 : this.rowNumber;
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public short getShort(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.abortIfClosed();
        return this.pstmt;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public String getString(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Time getTime(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber > this.rowCount;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == this.rowCount;
    }

    @Override
    public boolean last() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ601");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ601");
    }

    @Override
    public boolean next() throws SQLException {
        this.abortIfClosed();
        int n = this.rowNumber = this.rowNumber <= this.rowCount ? this.rowNumber + 1 : this.rowNumber;
        if (this.rowNumber <= this.rowCount) {
            this.receiveResults();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNCharacterStream(String)");
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNString(int)");
    }

    @Override
    public String getNString(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNString(String)");
    }

    @Override
    public boolean isClosed() {
        return this.rawMessageReceived == null;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(int,InputStream)");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(int,InputStream,long)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(String,InputStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream(String,InputStream,long)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(int,InputStream)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(int,InputStream,long)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(String,InputStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(String,InputStream,long)");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(int,InputStream");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(int,InputStream,long)");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(String,InputStream");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(String,InputStream,long)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(int,Reader)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(String,Reader)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(int,Reader");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(int,Reader,long)");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(String,Reader)");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(String,Reader,long");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(int,Reader)");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(String,Reader)");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(int,Reader)");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(int,Reader,long)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(String,Reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(String,Rader,long)");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNString(int,String)");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNString(String,String)");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNClob(int)");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNClob(String)");
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getRowId(int)");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getRowId(String)");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getSQLXML(int");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getSQLXML(String)");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(int,NClob)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(String,NClob)");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateRowId(int,RowId");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateRowId(String,RowId)");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateSQLXML(int,SQLXML)");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateSQLXML(int,SQLXML)");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

