/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.TeraConnectionPoolDataSource;
import com.teradata.jdbc.TeraPooledConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;

public class TeraLogicalConnection
implements Connection {
    private TeraPooledConnection myPooledCon = null;
    private Connection realConnection = null;
    private TeraConnectionPoolDataSource dataSource = null;
    private boolean isOpen = true;

    TeraLogicalConnection(TeraConnectionPoolDataSource teraConnectionPoolDataSource, TeraPooledConnection teraPooledConnection, Connection connection) {
        this.dataSource = teraConnectionPoolDataSource;
        if (this.logging()) {
            this.logit("New " + this);
        }
        this.realConnection = connection;
        this.myPooledCon = teraPooledConnection;
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.getMyConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.dataSource.logging()) {
            this.logit("Close " + this);
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ187");
        }
        this.setOpenState(false);
        this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon()));
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.getMyConnection().commit();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.getMyConnection().createStatement();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getMyConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.getMyConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Connection getMyConnection() throws SQLException {
        if (this.isClosed()) {
            if (this.dataSource.logging()) {
                this.logit("Close called but connection is already closed" + this);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ186");
        }
        return this.realConnection;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getMyConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getMyConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getMyConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getMyConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getMyConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public boolean logging() {
        return this.dataSource.logging();
    }

    public void logit(String string) {
        this.dataSource.logit(string);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            return this.getMyConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.getMyConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getMyConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.getMyConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getMyConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getMyConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.getMyConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PooledConnection getMyPooledCon() {
        return this.myPooledCon;
    }

    public void setOpenState(boolean bl) {
        this.isOpen = bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.getMyConnection().setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.getMyConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getMyConnection().setSavepoint();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            return this.getMyConnection().setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getMyConnection().rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getMyConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getMyConnection().createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getMyConnection().createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getMyConnection().getClientInfo();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            return this.getMyConnection().getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    private Connection getMyConnectionClientInfo() throws SQLClientInfoException {
        try {
            return this.getMyConnection();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new HashMap<String, ClientInfoStatus>(), sQLException);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getMyConnectionClientInfo().setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLClientInfoException));
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.getMyConnectionClientInfo().setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLClientInfoException));
            throw sQLClientInfoException;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        try {
            return this.getMyConnection().isValid(n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getMyConnection().createSQLXML();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.getMyConnection().createNClob();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.getMyConnection().createBlob();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.getMyConnection().createClob();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return this.getMyConnection().unwrap(clazz);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            return this.getMyConnection().isWrapperFor(clazz);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        try {
            this.getMyConnection().setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.getMyConnection().getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.getMyConnection().abort(executor);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.getMyConnection().getSchema();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        try {
            this.getMyConnection().setSchema(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }
}

