/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.ollama.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.List;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.exec.DBCException;

public class OllamaRequestBuilder {
    public static HttpRequest createHTTPRequest(String model, String hostname, List<DAICompletionMessage> messages, Double temperature, int contextSize) throws DBCException {
        String requestJson = AIRequest.createRequestJson(model, messages, temperature, contextSize);
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.header("Content-type", "application/json");
        try {
            URI uri = new URI(hostname).resolve("/api/chat");
            builder.uri(uri);
            builder.POST(HttpRequest.BodyPublishers.ofString(requestJson));
        }
        catch (URISyntaxException e) {
            throw new DBCException("Incorrect URI", (Throwable)e);
        }
        return builder.build();
    }

    private static class AIRequest {
        private AIRequest() {
        }

        public static String createRequestJson(String model, List<DAICompletionMessage> messageList, Double temperature, int contextSize) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("model", model);
            JsonArray elements = new JsonArray();
            jsonObject.add("messages", (JsonElement)elements);
            for (DAICompletionMessage daiCompletionMessage : messageList) {
                JsonObject messageJson = new JsonObject();
                DAICompletionMessage.Role role = daiCompletionMessage.getRole();
                switch (role) {
                    case USER: {
                        messageJson.addProperty("role", "user");
                        break;
                    }
                    case ASSISTANT: {
                        messageJson.addProperty("role", "assistant");
                        break;
                    }
                    case SYSTEM: {
                        messageJson.addProperty("role", "system");
                    }
                }
                messageJson.addProperty("content", daiCompletionMessage.getContent());
                elements.add((JsonElement)messageJson);
            }
            jsonObject.addProperty("stream", Boolean.valueOf(false));
            JsonObject generationConfig = new JsonObject();
            jsonObject.add("options", (JsonElement)generationConfig);
            generationConfig.addProperty("temperature", (Number)temperature);
            generationConfig.addProperty("num_ctx", (Number)contextSize);
            return jsonObject.toString();
        }
    }
}

