/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.ollama;

import com.dbeaver.model.ai.ollama.http.AIModelsDTO;
import com.dbeaver.model.ai.ollama.http.OllamaRequestBuilder;
import com.dbeaver.model.ai.ollama.http.OllamaResponseDTO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.completion.AbstractAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.ai.metadata.MetadataProcessor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class OllamaAiCompletionEngine
extends AbstractAICompletionEngine<HttpClient, HttpRequest> {
    protected static final Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Log log = Log.getLog(OllamaAiCompletionEngine.class);
    private static final Map<String, HttpClient> clientInstances = new HashMap<String, HttpClient>();

    public String getEngineName() {
        return "Ollama";
    }

    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getHostname()) && !CommonUtils.isEmpty((String)this.getModelName()) && this.getContextSize() > 0;
    }

    public Map<String, HttpClient> getServiceMap() {
        return clientInstances;
    }

    protected int getMaxTokens() {
        return this.getContextSize();
    }

    public static List<String> loadModels(String hostname, DBRProgressMonitor monitor) throws URISyntaxException, IOException, InterruptedException {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest request = HttpRequest.newBuilder(new URI(hostname).resolve("/api/tags")).build();
        if (monitor.isCanceled()) {
            return List.of();
        }
        monitor.subTask("Querying models...");
        CompletableFuture<HttpResponse<String>> responseFuture = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        while (!responseFuture.isDone()) {
            if (!monitor.isCanceled()) continue;
            responseFuture.cancel(true);
            throw new InterruptedException();
        }
        HttpResponse response = responseFuture.getNow(null);
        if (response == null) {
            return List.of();
        }
        AIModelsDTO aiModelsDTO = (AIModelsDTO)gson.fromJson((String)response.body(), AIModelsDTO.class);
        return Arrays.stream(aiModelsDTO.models()).map(AIModelsDTO.Model::name).toList();
    }

    @Nullable
    protected String callCompletion(@NotNull DBRProgressMonitor monitor, boolean chatMode, @NotNull List<DAICompletionMessage> messages, @NotNull HttpClient client, @NotNull HttpRequest completionRequest) throws DBException {
        try {
            CompletableFuture<HttpResponse<String>> responseAsync = client.sendAsync(completionRequest, HttpResponse.BodyHandlers.ofString());
            while (!responseAsync.isDone()) {
                if (!monitor.isCanceled()) continue;
                responseAsync.cancel(true);
                throw new InterruptedException();
            }
            HttpResponse response = responseAsync.getNow(null);
            if (response == null) {
                throw new DBException("No response recieved");
            }
            if (response.statusCode() != 200) {
                throw new DBException("Error requesting completion " + (String)response.body());
            }
            OllamaResponseDTO aiResponseDTO = (OllamaResponseDTO)gson.fromJson((String)response.body(), OllamaResponseDTO.class);
            return aiResponseDTO.message().content();
        }
        catch (InterruptedException | NoSuchElementException e) {
            throw new DBException("Error requesting completion", (Throwable)e);
        }
    }

    protected HttpClient getServiceInstance(@NotNull DBCExecutionContext executionContext) throws DBException {
        DBPDataSourceContainer container = executionContext.getDataSource().getContainer();
        HttpClient service = clientInstances.get(container.getId());
        if (service == null) {
            service = this.initHttpClientInstance();
            clientInstances.put(container.getId(), service);
        }
        return service;
    }

    private HttpClient initHttpClientInstance() throws DBException {
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.connectTimeout(Duration.ofSeconds(30L));
        return builder.build();
    }

    protected AIEngineSettings getSettings() {
        return AISettingsRegistry.getInstance().getSettings().getEngineConfiguration("ollama");
    }

    protected HttpRequest createCompletionRequest(boolean chatMode, @NotNull List<DAICompletionMessage> messages, int maxTokens) throws DBCException {
        Double temperature = CommonUtils.toDouble(this.getSettings().getProperties().get("gpt.model.temperature"), (double)0.0);
        return OllamaRequestBuilder.createHTTPRequest(this.getModelName(), this.getHostname(), OllamaAiCompletionEngine.truncateMessages((boolean)chatMode, messages, (int)maxTokens), temperature, this.getContextSize());
    }

    protected HttpRequest createCompletionRequest(boolean chatMode, @NotNull List<DAICompletionMessage> messages) throws DBCException {
        return this.createCompletionRequest(chatMode, (List)messages, this.getMaxTokens());
    }

    @Nullable
    protected String requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull List<DAICompletionMessage> messages, @NotNull IAIFormatter formatter, boolean chatCompletion) throws DBException {
        DBCExecutionContext executionContext = context.getExecutionContext();
        DBSObjectContainer mainObject = this.getScopeObject(context, executionContext);
        DAICompletionMessage metadataMessage = MetadataProcessor.INSTANCE.createMetadataMessage(monitor, context, mainObject, formatter, this.getInstructions(chatCompletion), this.getMaxTokens() - 2000);
        ArrayList<DAICompletionMessage> mergedMessages = new ArrayList<DAICompletionMessage>();
        mergedMessages.add(metadataMessage);
        mergedMessages.addAll(messages);
        Object completionRequest = this.createCompletionRequest(chatCompletion, mergedMessages);
        HttpClient service = this.getServiceInstance(executionContext);
        String completionText = this.callCompletion(monitor, chatCompletion, mergedMessages, service, (HttpRequest)completionRequest);
        if (CommonUtils.toBoolean(this.getSettings().getProperties().get("gpt.log.query"))) {
            log.debug((Object)("Ollama response:\n" + completionText));
        }
        return this.processCompletion(mergedMessages, monitor, executionContext, mainObject, completionText, formatter, true);
    }

    protected String getHostname() {
        AIEngineSettings config = this.getSettings();
        return CommonUtils.toString(config.getProperties().get("ollama.hostname"));
    }

    public String getModelName() {
        return CommonUtils.toString(this.getSettings().getProperties().get("ollama.model"));
    }

    protected int getContextSize() {
        AIEngineSettings config = this.getSettings();
        return CommonUtils.toInt(config.getProperties().get("ollama.context.size"), (int)-1);
    }
}

