/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.gemini.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.exec.DBCException;

public class GeminiRequestBuilder {
    public static HttpRequest createHTTPRequest(String token, List<DAICompletionMessage> messages, Double temperature) throws DBCException {
        String requestJson = AIRequest.createRequestJson(messages, temperature);
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.header("Content-type", "application/json");
        try {
            String encodedToken = URLEncoder.encode(token, StandardCharsets.UTF_8);
            URI uri = new URI("https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=" + encodedToken);
            builder.uri(uri);
            builder.POST(HttpRequest.BodyPublishers.ofString(requestJson));
        }
        catch (URISyntaxException e) {
            throw new DBCException("Incorrect URI", (Throwable)e);
        }
        return builder.build();
    }

    private static class AIRequest {
        private AIRequest() {
        }

        public static String createRequestJson(List<DAICompletionMessage> messageList, Double temperature) {
            JsonObject jsonObject = new JsonObject();
            JsonArray elements = new JsonArray();
            jsonObject.add("contents", (JsonElement)elements);
            for (DAICompletionMessage daiCompletionMessage : messageList) {
                JsonObject messageJson = new JsonObject();
                messageJson.addProperty("role", daiCompletionMessage.getRole() == DAICompletionMessage.Role.ASSISTANT ? "model" : daiCompletionMessage.getRole().getId());
                JsonArray partsArray = new JsonArray();
                messageJson.add("parts", (JsonElement)partsArray);
                JsonObject textElement = new JsonObject();
                textElement.addProperty("text", daiCompletionMessage.getContent());
                partsArray.add((JsonElement)textElement);
                elements.add((JsonElement)messageJson);
            }
            JsonObject generationConfig = new JsonObject();
            jsonObject.add("generationConfig", (JsonElement)generationConfig);
            generationConfig.addProperty("temperature", (Number)temperature);
            generationConfig.addProperty("topP", (Number)0.1);
            JsonArray stopSequences = new JsonArray();
            stopSequences.add("#");
            stopSequences.add(";");
            return jsonObject.toString();
        }
    }
}

