/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.gemini;

import com.dbeaver.model.ai.gemini.http.AIResponseDTO;
import com.dbeaver.model.ai.gemini.http.GeminiRequestBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.completion.AbstractAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.ai.metadata.MetadataProcessor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class GeminiAiCompletionEngine
extends AbstractAICompletionEngine<HttpClient, HttpRequest> {
    protected static final Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Log log = Log.getLog(GeminiAiCompletionEngine.class);
    private static final Map<String, HttpClient> clientInstances = new HashMap<String, HttpClient>();

    public String getEngineName() {
        return "Google Gemini";
    }

    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.acquireToken());
    }

    public Map<String, HttpClient> getServiceMap() {
        return clientInstances;
    }

    protected int getMaxTokens() {
        return 30720;
    }

    @Nullable
    protected String callCompletion(@NotNull DBRProgressMonitor monitor, boolean chatMode, @NotNull List<DAICompletionMessage> messages, @NotNull HttpClient client, @NotNull HttpRequest completionRequest) throws DBException {
        try {
            HttpResponse<String> response = client.send(completionRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new DBException("Error requesting completion " + response.body());
            }
            AIResponseDTO aiResponseDTO = (AIResponseDTO)gson.fromJson(response.body(), AIResponseDTO.class);
            return ((AIResponseDTO.Candidate.ContentPart)((AIResponseDTO.Candidate)aiResponseDTO.candidates().stream().findFirst().orElseThrow()).content().parts().stream().findFirst().orElseThrow()).text();
        }
        catch (IOException | InterruptedException | NoSuchElementException e) {
            throw new DBException("Error requesting completion", (Throwable)e);
        }
    }

    protected HttpClient getServiceInstance(@NotNull DBCExecutionContext executionContext) throws DBException {
        DBPDataSourceContainer container = executionContext.getDataSource().getContainer();
        HttpClient service = clientInstances.get(container.getId());
        if (service == null) {
            service = this.initHttpClientInstance();
            clientInstances.put(container.getId(), service);
        }
        return service;
    }

    private HttpClient initHttpClientInstance() throws DBException {
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.connectTimeout(Duration.ofSeconds(30L));
        return builder.build();
    }

    protected AIEngineSettings getSettings() {
        return AISettingsRegistry.getInstance().getSettings().getEngineConfiguration("google-gemini");
    }

    @NotNull
    protected String getInstructions(boolean chatCompletion) {
        return "Perform SQL completion.\nQuery MUST start with \"SELECT\" and MUST be ENCLOSED with Markdown code block and terminated with semicolon.\nYou MAY add comments but placed OUTSIDE Markdown code block.\n";
    }

    protected HttpRequest createCompletionRequest(boolean chatMode, @NotNull List<DAICompletionMessage> messages, int maxTokens) throws DBCException {
        Double temperature = CommonUtils.toDouble(this.getSettings().getProperties().get("gpt.model.temperature"), (double)0.0);
        return GeminiRequestBuilder.createHTTPRequest(this.acquireToken(), GeminiAiCompletionEngine.truncateMessages((boolean)chatMode, messages, (int)maxTokens), temperature);
    }

    protected HttpRequest createCompletionRequest(boolean chatMode, @NotNull List<DAICompletionMessage> messages) throws DBCException {
        return this.createCompletionRequest(chatMode, (List)messages, this.getMaxTokens());
    }

    @Nullable
    protected String requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull List<DAICompletionMessage> messages, @NotNull IAIFormatter formatter, boolean chatCompletion) throws DBException {
        DBCExecutionContext executionContext = context.getExecutionContext();
        DBSObjectContainer mainObject = this.getScopeObject(context, executionContext);
        DAICompletionMessage metadataMessage = MetadataProcessor.INSTANCE.createMetadataMessage(monitor, context, mainObject, formatter, this.getInstructions(chatCompletion), this.getMaxTokens() - 2000);
        List<DAICompletionMessage> mergedMessages = GeminiAiCompletionEngine.updateMessagesWithMetadata(messages, metadataMessage);
        Object completionRequest = this.createCompletionRequest(chatCompletion, (List)mergedMessages);
        HttpClient service = this.getServiceInstance(executionContext);
        String completionText = this.callCompletion(monitor, chatCompletion, mergedMessages, service, (HttpRequest)completionRequest);
        if (CommonUtils.toBoolean(this.getSettings().getProperties().get("gpt.log.query"))) {
            log.debug((Object)("Gemini response:\n" + completionText));
        }
        return this.processCompletion(mergedMessages, monitor, executionContext, mainObject, completionText, formatter, true);
    }

    @NotNull
    protected List<DAICompletionMessage> filterMessages(List<DAICompletionMessage> messages, boolean includeAssistantMessages) {
        return messages;
    }

    @NotNull
    private static List<DAICompletionMessage> updateMessagesWithMetadata(@NotNull List<DAICompletionMessage> messages, DAICompletionMessage metadataMessage) throws DBException {
        if (messages.isEmpty()) {
            throw new DBException("Empty message list");
        }
        DAICompletionMessage oldMessage = messages.get(messages.size() - 1);
        DAICompletionMessage message = new DAICompletionMessage(DAICompletionMessage.Role.USER, metadataMessage.getContent() + "\n" + oldMessage.getContent());
        ArrayList<DAICompletionMessage> mergedMessages = new ArrayList<DAICompletionMessage>();
        int i = 0;
        while (i < messages.size() - 1) {
            mergedMessages.add(messages.get(i));
            ++i;
        }
        mergedMessages.add(message);
        return mergedMessages;
    }

    protected String acquireToken() {
        AIEngineSettings config = this.getSettings();
        Object token = config.getProperties().get("gemini.token");
        if (token == null) {
            return null;
        }
        return (String)token;
    }
}

