/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.format;

import com.dbeaver.model.ai.AICompletionJoinRule;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.ai.format.DefaultRequestFormatter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AdvancedRequestFormatter
extends DefaultRequestFormatter {
    public String postProcessGeneratedQuery(DBRProgressMonitor monitor, DBSObjectContainer mainObject, DBCExecutionContext executionContext, String completionText) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.formatSqlQuery")) {
            completionText = SQLFormatUtils.formatSQL((DBPDataSource)executionContext.getDataSource(), (String)completionText);
        }
        return completionText;
    }

    @Nullable
    public String getExtraInstructions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer mainObject, @NotNull DBCExecutionContext executionContext) {
        AICompletionJoinRule joinRule = (AICompletionJoinRule)CommonUtils.valueOf(AICompletionJoinRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.joinRule"), (Enum)AICompletionJoinRule.DEFAULT);
        return switch (joinRule) {
            case AICompletionJoinRule.JOIN -> "use joins";
            case AICompletionJoinRule.SUB_QUERY -> "use subqueries";
            default -> null;
        };
    }

    public void addExtraDescription(DBRProgressMonitor monitor, DBSEntity object, StringBuilder description, DBPObjectWithDescription lastAttr) throws DBException {
        boolean firstRA;
        List refAttrs;
        Collection associations;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.useConstraints") && (associations = object.getConstraints(monitor)) != null && !associations.isEmpty()) {
            for (DBSEntityConstraint association : associations) {
                DBSEntityConstraintType type = association.getConstraintType();
                if (type != DBSEntityConstraintType.PRIMARY_KEY && type != DBSEntityConstraintType.UNIQUE_KEY || CommonUtils.isEmpty((Collection)(refAttrs = ((DBSEntityReferrer)association).getAttributeReferences(monitor)))) continue;
                if (lastAttr != null) {
                    description.append(",");
                    if (lastAttr instanceof DBSEntityAttribute) {
                        this.addObjectDescriptionIfNeeded(description, lastAttr, monitor);
                    }
                    description.append("\n\t");
                }
                lastAttr = association;
                description.append(type == DBSEntityConstraintType.PRIMARY_KEY ? "PRIMARY" : "UNIQUE");
                description.append(" KEY(");
                firstRA = true;
                for (DBSEntityAttributeRef ar : refAttrs) {
                    if (ar.getAttribute() == null) continue;
                    if (!firstRA) {
                        description.append(",");
                    }
                    firstRA = false;
                    description.append(ar.getAttribute().getName());
                }
                description.append(")");
            }
        }
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.useForeignKeys") && (associations = object.getAssociations(monitor)) != null) {
            for (DBSEntityConstraint association : associations) {
                if (!(association instanceof DBSEntityReferrer)) continue;
                DBSEntity refEntity = association.getAssociatedEntity();
                refAttrs = ((DBSEntityReferrer)association).getAttributeReferences(monitor);
                if (refEntity == null || CommonUtils.isEmpty((Collection)refAttrs)) continue;
                if (lastAttr != null) {
                    description.append(",");
                    if (lastAttr instanceof DBSEntityAttribute) {
                        this.addObjectDescriptionIfNeeded(description, lastAttr, monitor);
                    }
                    description.append("\n\t");
                }
                lastAttr = association;
                description.append("FOREIGN KEY(");
                firstRA = true;
                for (DBSEntityAttributeRef ar : refAttrs) {
                    if (ar.getAttribute() == null) continue;
                    if (!firstRA) {
                        description.append(",\n\t");
                    }
                    firstRA = false;
                    description.append(ar.getAttribute().getName());
                }
                description.append(") REFERENCES ").append(refEntity.getName());
            }
        }
    }
}

