/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.azure.model.api;

import com.dbeaver.model.ai.azure.model.api.AzureOpenAiAPI;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.model.Model;
import io.reactivex.Single;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jkiss.dbeaver.model.ai.openai.service.GPTCompletionAdapter;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class AzureOpenAiService
implements GPTCompletionAdapter {
    private static final ObjectMapper mapper = AzureOpenAiService.defaultObjectMapper();
    private final AzureOpenAiAPI api;
    private final String deployment;
    private final ExecutorService executorService;
    private final String apiVersion;

    public AzureOpenAiService(String token, String baseUrl, String deployment, String apiVersion, Duration timeout) {
        this.deployment = deployment;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().header("Content-Type", "application/json").header("Cache-Control", "no-cache").header("api-key", token).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        this.api = (AzureOpenAiAPI)retrofit.create(AzureOpenAiAPI.class);
        this.executorService = client.dispatcher().executorService();
        this.apiVersion = apiVersion;
    }

    public List<Model> listModels(String apiVersion) {
        return AzureOpenAiService.execute(this.api.listModels((String)apiVersion)).data;
    }

    public Model getModel(String modelId, String apiVersion) {
        return AzureOpenAiService.execute(this.api.getModel(modelId, apiVersion));
    }

    public CompletionResult createCompletion(CompletionRequest request) {
        return AzureOpenAiService.execute(this.api.createCompletion(request, this.deployment, this.apiVersion));
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        return AzureOpenAiService.execute(this.api.createChatCompletion(request, this.deployment, this.apiVersion));
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return AzureOpenAiService.execute(this.api.createEmbeddings(request, this.deployment, this.apiVersion));
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            e.printStackTrace();
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                OpenAiError error = (OpenAiError)mapper.readValue(errorBody, OpenAiError.class);
                throw new OpenAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException iOException) {
                throw e;
            }
        }
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }
}

