/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.azure.model.api;

import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.model.Model;
import io.reactivex.Single;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;

public interface AzureOpenAiAPI {
    @GET(value="/openai/models")
    public Single<OpenAiResponse<Model>> listModels(@Query(value="api-version") String var1);

    @GET(value="/openai/models/{model_id}")
    public Single<Model> getModel(@Path(value="model_id") String var1, @Query(value="api-version") String var2);

    @POST(value="/openai/deployments/{deployment_id}/completions")
    public Single<CompletionResult> createCompletion(@Body CompletionRequest var1, @Path(value="deployment_id") String var2, @Query(value="api-version") String var3);

    @Streaming
    @POST(value="/openai/deployments/{deployment_id}/completions")
    public Call<ResponseBody> createCompletionStream(@Body CompletionRequest var1, @Path(value="deployment_id") String var2, @Query(value="api-version") String var3);

    @POST(value="/openai/deployments/{deployment_id}/chat/completions")
    public Single<ChatCompletionResult> createChatCompletion(@Body ChatCompletionRequest var1, @Path(value="deployment_id") String var2, @Query(value="api-version") String var3);

    @Streaming
    @POST(value="/openai/deployments/{deployment_id}/chat/completions")
    public Call<ResponseBody> createChatCompletionStream(@Body ChatCompletionRequest var1, @Path(value="deployment_id") String var2, @Query(value="api-version") String var3);

    @GET(value="/openai/files")
    public Single<OpenAiResponse<File>> listFiles(@Query(value="api-version") String var1);

    @Multipart
    @POST(value="/openai/files")
    public Single<File> uploadFile(@Part(value="purpose") RequestBody var1, @Part MultipartBody.Part var2, @Query(value="api-version") String var3);

    @GET(value="/openai/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1, @Query(value="api-version") String var2);

    @POST(value="/openai/fine-tunes")
    public Single<FineTuneResult> createFineTune(@Body FineTuneRequest var1, @Query(value="api-version") String var2);

    @GET(value="/openai/fine-tunes/{fine_tune_id}")
    public Single<FineTuneResult> retrieveFineTune(@Path(value="fine_tune_id") String var1, @Query(value="api-version") String var2);

    @POST(value="/openai/deployments/{deployment_id}/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body EmbeddingRequest var1, @Path(value="deployment_id") String var2, @Query(value="api-version") String var3);
}

