/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.azure.model;

import com.dbeaver.model.ai.azure.model.api.AzureOpenAiService;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.openai.GPTModel;
import org.jkiss.dbeaver.model.ai.openai.OpenAICompletionEngine;
import org.jkiss.dbeaver.model.ai.openai.service.GPTCompletionAdapter;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import retrofit2.HttpException;

public class AzureAICompletionEngine
extends OpenAICompletionEngine {
    private static final Log log = Log.getLog(AzureAICompletionEngine.class);
    private static final String API_VERSION = "2023-05-15";
    private Map<String, Integer> deploymentsMaxTokens = new HashMap<String, Integer>();

    protected GPTCompletionAdapter initGPTApiClientInstance() throws DBException {
        AIEngineSettings settings = this.getSettings();
        String token = this.acquireToken();
        String url = CommonUtils.toString(settings.getProperties().get("azure.endpoint.url"), (String)"");
        String deployment = this.getDeployment();
        AzureOpenAiService service = new AzureOpenAiService(token, url, deployment, API_VERSION, Duration.ofSeconds(30L));
        if (!this.deploymentsMaxTokens.containsKey(deployment)) {
            int deploymentMaxTokens = this.computeMaxTokens(service);
            this.deploymentsMaxTokens.put(deployment, deploymentMaxTokens);
        }
        return service;
    }

    private String getDeployment() {
        return CommonUtils.toString(this.getSettings().getProperties().get("azure.deployment"), (String)"");
    }

    private int computeMaxTokens(AzureOpenAiService azureOpenAiService) throws DBException {
        ChatCompletionRequest completionRequest = ChatCompletionRequest.builder().messages(List.of(new ChatMessage("user", "ping"))).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(40)).frequencyPenalty(Double.valueOf(0.0)).presencePenalty(Double.valueOf(0.0)).n(Integer.valueOf(1)).stop(List.of("#", ";")).model(this.getModelName()).build();
        try {
            int i = 0;
            while (i < 3) {
                try {
                    ChatCompletionResult completionResult = azureOpenAiService.createChatCompletion(completionRequest);
                    GPTModel model = GPTModel.getByName((String)completionResult.getModel());
                    return model.getMaxTokens();
                }
                catch (HttpException e) {
                    if (e.code() != 429) {
                        throw e;
                    }
                    RuntimeUtils.pause((int)1000);
                    log.debug((Object)("AI service failed. Retry (" + e.getMessage() + ")"));
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new DBException("Error reading deployment info", (Throwable)exception);
        }
        throw new DBException("Error reading deployment info, max amount of retries reached");
    }

    protected int getMaxTokens() {
        Integer value = this.deploymentsMaxTokens.get(this.getDeployment());
        return value == null ? GPTModel.GPT_TURBO.getMaxTokens() : value.intValue();
    }

    @NotNull
    protected AIEngineSettings getSettings() {
        return AISettingsRegistry.getInstance().getSettings().getEngineConfiguration("azure-openai");
    }

    public boolean isValidConfiguration() {
        return super.isValidConfiguration() && this.getSettings().getProperties().get("azure.endpoint.url") != null && this.getSettings().getProperties().get("azure.deployment") != null;
    }

    public String getEngineName() {
        return "Azure GPT";
    }
}

