/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.ui.config;

import com.dbeaver.db.cassandra.model.CasTableColumn;
import com.dbeaver.db.cassandra.model.CasTableIndex;
import com.dbeaver.db.cassandra.model.CasTableIndexColumn;
import com.dbeaver.db.cassandra.ui.internal.CasUIMessages;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.utils.CommonUtils;

public class CasTableIndexConfigurator
implements DBEObjectConfigurator<CasTableIndex> {
    public CasTableIndex configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object table, final @NotNull CasTableIndex index, @NotNull Map<String, Object> options) {
        return (CasTableIndex)new UITask<CasTableIndex>(){

            protected CasTableIndex runTask() {
                CreateIndexPage indexPage = new CreateIndexPage(CasUIMessages.index_configurator_page_label, (DBSTableIndex)index);
                if (!indexPage.edit()) {
                    return null;
                }
                index.setCustom(indexPage.isCustom());
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)index.getTable().getName()));
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : indexPage.getSelectedAttributes()) {
                    if (colIndex == 1) {
                        idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                    }
                    index.addIndexColumn(new CasTableIndexColumn(index, (CasTableColumn)tableColumn));
                    ++colIndex;
                }
                idxName.append("_idx");
                index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
                if (indexPage.isCustom()) {
                    index.setIndexClassName(indexPage.getIndexClass());
                }
                return index;
            }
        }.execute();
    }

    private static class CreateIndexPage
    extends AttributesSelectorPage {
        private String indexClass;
        private boolean isCustom;
        private Button customButton;
        private Text indexClassText;

        CreateIndexPage(String title, DBSTableIndex index) {
            super(title, index.getTable());
        }

        boolean isCustom() {
            return this.isCustom;
        }

        String getIndexClass() {
            return this.indexClass;
        }

        protected void createContentsBeforeColumns(Composite panel) {
            this.customButton = UIUtils.createLabelCheckbox((Composite)panel, (String)CasUIMessages.index_configurator_page_checkbox_custom, (boolean)false);
            this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    isCustom = customButton.getSelection();
                    if (indexClassText != null) {
                        indexClassText.setEnabled(customButton.getSelection());
                    }
                }
            });
        }

        protected void createContentsAfterColumns(Composite panel) {
            Composite classGroup = new Composite(panel, 0);
            classGroup.setLayout((Layout)new GridLayout(2, false));
            classGroup.setLayoutData((Object)new GridData(768));
            this.indexClassText = UIUtils.createLabelText((Composite)classGroup, (String)CasUIMessages.index_configurator_page_text_index_class, (String)"", (int)2050);
            this.indexClassText.setEnabled(this.customButton != null && this.customButton.getSelection());
            this.indexClassText.addModifyListener(e -> {
                String string = this.indexClass = this.indexClassText.getText();
            });
        }

        public DBSObject getObject() {
            return null;
        }
    }
}

