/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.LogicalDatabaseTransparentDataEncryptionInner;
import com.azure.resourcemanager.sql.models.TransparentDataEncryption;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionState;
import reactor.core.publisher.Mono;

class TransparentDataEncryptionImpl
extends RefreshableWrapperImpl<LogicalDatabaseTransparentDataEncryptionInner, TransparentDataEncryption>
implements TransparentDataEncryption {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected TransparentDataEncryptionImpl(String resourceGroupName, String sqlServerName, LogicalDatabaseTransparentDataEncryptionInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((LogicalDatabaseTransparentDataEncryptionInner)((Object)this.innerModel())).id());
    }

    public String name() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public TransparentDataEncryptionState status() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)((Object)this.innerModel())).state();
    }

    @Override
    public TransparentDataEncryption updateStatus(TransparentDataEncryptionState transparentDataEncryptionState) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdate(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT, new LogicalDatabaseTransparentDataEncryptionInner().withState(transparentDataEncryptionState));
        this.refresh();
        return this;
    }

    @Override
    public Mono<TransparentDataEncryption> updateStatusAsync(TransparentDataEncryptionState transparentDataEncryptionState) {
        TransparentDataEncryptionImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.databaseName(), TransparentDataEncryptionName.CURRENT, new LogicalDatabaseTransparentDataEncryptionInner().withState(transparentDataEncryptionState)).then(this.refreshAsync());
    }

    protected Mono<LogicalDatabaseTransparentDataEncryptionInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT);
    }
}

