/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.document.data.DBDocumentUtils;
import java.util.Map;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.utils.CommonUtils;

public class MGOperation
extends AbstractServerSession {
    public static final String CAT_GENERAL = "General";
    public static final String CAT_CLIENT = "Client";
    private final MGDataSource dataSource;
    private final Map<String, Object> operation;

    public MGOperation(MGDataSource dataSource, Map<String, Object> operation) {
        this.dataSource = dataSource;
        this.operation = operation;
    }

    @Property(category="General", viewable=true, order=1)
    public Object getId() {
        return this.operation.get("opid");
    }

    @Property(category="General", viewable=true, order=2)
    public String getOperation() {
        return CommonUtils.toString((Object)this.operation.get("op"));
    }

    @Property(category="General", viewable=true, order=3)
    public String getCommand() {
        Object command = this.operation.get("command");
        if (command == null) {
            command = this.operation.get("query");
        }
        if (command instanceof Map) {
            return DBDocumentUtils.convertValueToJson((DBPDataSource)this.dataSource, (Object)command);
        }
        return CommonUtils.toString((Object)command);
    }

    @Property(category="General", viewable=true, order=4)
    public String getHost() {
        return CommonUtils.toString((Object)this.operation.get("host"));
    }

    @Property(category="General", viewable=true, order=5)
    public String getNs() {
        return CommonUtils.toString((Object)this.operation.get("ns"));
    }

    @Property(category="General", viewable=true, length=PropertyLength.MULTILINE, order=6)
    public String getDescription() {
        return CommonUtils.toString((Object)this.operation.get("desc"));
    }

    @Property(category="General", viewable=true, order=7)
    public boolean isActive() {
        return CommonUtils.toBoolean((Object)this.operation.get("active"));
    }

    @Property(category="General", viewable=true, order=8)
    public String getCurrentOpTime() {
        return CommonUtils.toString((Object)this.operation.get("currentOpTime"));
    }

    @Property(category="Client", viewable=true, order=30)
    public String getClient() {
        return CommonUtils.toString((Object)this.operation.get("client"));
    }

    @Property(category="Client", viewable=false, order=31)
    public String getAppName() {
        return CommonUtils.toString((Object)this.operation.get("appName"));
    }

    @Property(category="Client", viewable=false, order=32)
    public String getClientMetadata() {
        Object metadata = this.operation.get("clientMetadata");
        if (metadata instanceof Map) {
            return DBDocumentUtils.convertValueToJson((DBPDataSource)this.dataSource, (Object)metadata);
        }
        return CommonUtils.toString((Object)metadata);
    }

    @Property(category="Client", viewable=false, order=33)
    public Number getConnectionId() {
        return (Number)this.operation.get("connectionId");
    }

    public String getActiveQuery() {
        String command = this.getCommand();
        if (CommonUtils.isEmpty((String)command)) {
            command = this.getOperation();
        }
        return command;
    }

    public String toString() {
        return this.getNs() + " " + this.getOperation() + " @" + this.getClient();
    }
}

