/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.exec.MGExecutionContext;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.model.MGDataSourceInfo;
import com.dbeaver.db.mongodb.model.MGDataType;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.dbeaver.db.mongodb.model.MGOperationManager;
import com.dbeaver.db.mongodb.model.MGSQLDialect;
import com.dbeaver.db.mongodb.model.MGTypeConverters;
import com.dbeaver.model.NoSQLDataSource;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBDocumentElement;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoSocketException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Version;

public abstract class MGDataSource
extends NoSQLDataSource<MGExecutionContext>
implements DocumentDataManager<MGDataSource, Map<String, Object>>,
DBPRefreshableObject,
DBPObjectStatisticsCollector,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(MGDataSource.class);
    private final Gson JSON_BUILDER;
    private Version serverVersion;
    private final DatabaseCache databaseCache = new DatabaseCache();
    private MGDataSourceInfo info;
    private final List<MGDataType> dataTypes = new ArrayList<MGDataType>();
    private boolean hasStatistics;

    protected MGDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(container);
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        this.dataTypes.add(new MGDataType(this, 1, "ObjectId", "objectId"));
        this.dataTypes.add(new MGDataType(this, 2, "Document", "document"));
        this.dataTypes.add(new MGDataType(this, 3, "String", "string"));
        this.dataTypes.add(new MGDataType(this, 4, "Number", "number"));
        this.dataTypes.add(new MGDataType(this, 7, "Boolean", "boolean"));
        this.dataTypes.add(new MGDataType(this, 8, "Timestamp", "date"));
        this.dataTypes.add(new MGDataType(this, 9, "Binary", "byte[]"));
        this.dataTypes.add(new MGDataType(this, 10, "List", "array"));
        this.dataTypes.add(new MGDataType(this, 11, "Object", "object"));
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ObjectId.class, (Object)MGTypeConverters.ObjectIdTypeAdapter.INSTANCE).registerTypeAdapter(Binary.class, (Object)MGTypeConverters.UUIDTypeAdapter.INSTANCE).registerTypeAdapter(Date.class, (Object)new MGTypeConverters.ISODateTypeConverter()).registerTypeAdapter(BsonTimestamp.class, (Object)new MGTypeConverters.BsonTimestampConverter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").disableHtmlEscaping().serializeNulls();
        if (this.supportsDecimal128()) {
            gsonBuilder.registerTypeAdapter(Decimal128.class, (Object)new MGTypeConverters.Decimal128TypeConverter());
        }
        this.JSON_BUILDER = gsonBuilder.create();
        String defDatabase = connectionInfo.getDatabaseName();
        String url = connectionInfo.getUrl();
        if (MGUtils.isValidURL(url)) {
            url = MGUtils.transformURL(MGUtils.getMongoCredential(this, connectionInfo), url);
            try {
                defDatabase = new ConnectionString(url).getDatabase();
            }
            catch (Throwable e) {
                log.debug((Object)"Bad mongo URL", e);
            }
        }
        this.executionContext = new MGExecutionContext(this, "Main " + this.getDatabaseType() + " Connection", defDatabase);
        ((MGExecutionContext)this.executionContext).connect(monitor);
        Document buildInfo = ((MGExecutionContext)this.executionContext).getBuildInfo();
        Object version = buildInfo.get((Object)"version");
        if (version != null) {
            try {
                this.serverVersion = new Version(CommonUtils.toString((Object)version).replaceAll("[^\\d.]", ""));
            }
            catch (Exception e) {
                log.debug((Object)("Can't extract " + this.getDatabaseType() + " server version"), (Throwable)e);
            }
        }
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public boolean isServerVersionAtLeast(int major, int minor) {
        if (this.serverVersion == null) {
            return true;
        }
        if (this.serverVersion.getMajor() < major) {
            return false;
        }
        return this.serverVersion.getMajor() != major || this.serverVersion.getMinor() >= minor;
    }

    public MGExecutionContext getExecutionContext() {
        return (MGExecutionContext)this.executionContext;
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    @NotNull
    public MongoDatabase getAdminDatabase(MGSession session) throws DBCException {
        return session.getExecutionContext().getClient().getDatabase("admin");
    }

    @Association
    public Collection<MGDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public MGDatabase getDatabase(String name) {
        return (MGDatabase)this.databaseCache.getCachedObject(name);
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.document-data-source": {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @NotNull
    public MGExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        MGExecutionContext context = new MGExecutionContext(this, purpose, initFrom instanceof MGExecutionContext ? ((MGExecutionContext)initFrom).getSelectedDatabase() : this.getDefaultDatabase());
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            this.databaseCache.getAllObjects(monitor, this);
            this.info = new MGDataSourceInfo(this, ((MGExecutionContext)this.executionContext).getClient());
        }
        catch (Exception e) {
            throw new DBException("Error initializing " + this.getDatabaseType() + " context", (Throwable)e);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        this.hasStatistics = false;
        this.initialize(monitor);
        return this;
    }

    public String getDefaultDatabase() {
        return ((MGExecutionContext)this.executionContext).getSelectedDatabase();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MGOperationManager(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        Object term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = (String)term + "s";
        }
        return term;
    }

    public MGSQLDialect getSQLDialect() {
        return MGSQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MGDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        switch (typeID) {
            case 1: {
                return DBPDataKind.ROWID;
            }
            case 2: {
                return DBPDataKind.DOCUMENT;
            }
            case 3: {
                return DBPDataKind.STRING;
            }
            case 4: {
                return DBPDataKind.NUMERIC;
            }
            case 7: {
                return DBPDataKind.BOOLEAN;
            }
            case 8: {
                return DBPDataKind.DATETIME;
            }
            case 9: {
                return DBPDataKind.BINARY;
            }
            case 10: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.ANY;
    }

    public MGDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        MGDataType dataType = this.getLocalDataType(typeFullName);
        if (dataType == null || dataType.getTypeID() == 2) {
            return null;
        }
        return dataType;
    }

    public Collection<MGDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public MGDataType getLocalDataType(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public MGDataType getLocalDataType(int typeID) {
        for (MGDataType type : this.dataTypes) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }

    public MGDataType getDataTypeByJS(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getJsName().equals(typeName)) continue;
            return type;
        }
        return this.getDocumentDataType(11);
    }

    public boolean supportsDecimal128() {
        return true;
    }

    public MGDataType getDocumentDataType(int valueType) {
        return this.getLocalDataType(valueType);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "String";
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error.getCause() instanceof MongoSocketException) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        this.hasStatistics = true;
        for (MGDatabase db : this.getDatabases()) {
            try {
                db.readStatistics(monitor);
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
    }

    public void serializeDocument(Map<String, Object> document, Writer writer) {
        this.JSON_BUILDER.toJson(MGUtils.unwrapMongoValue(this, null, document), (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        StringWriter buf = new StringWriter();
        try {
            IOUtils.copyText((Reader)reader, (Writer)buf);
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        String json = buf.toString();
        BasicDBObject result = BasicDBObject.parse((String)json);
        this.updateParseResults((Map<String, Object>)result);
        return result;
    }

    public void updateParseResults(Map<String, Object> obj) {
        for (Map.Entry<String, Object> e : obj.entrySet()) {
            Object value = e.getValue();
            if (value instanceof UUID) {
                e.setValue(MGUtils.unwrapMongoValue(this, e.getKey(), value));
            }
            if (value instanceof ObjectId) {
                e.setValue(new DBDocumentElement("ObjectId", value, DBMapValue.MapValueType.OBJECT_ID));
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.updateParseResults((Map)value);
        }
    }

    public DBMapValue<MGDataSource> convertNativeDocumentToMap(Map<String, Object> dbObject) {
        return (DBMapValue)MGUtils.wrapMongoValue(this, dbObject, null);
    }

    public Map<String, Object> convertMapToNativeDocument(DBMapValue<MGDataSource> map) {
        return (Map)MGUtils.unwrapMongoValue(this, null, (Object)map.getRawValue());
    }

    public DBWHandlerConfiguration getCustomSSLConfiguration(DBRProgressMonitor monitor, DBPConnectionConfiguration connectionInfo) {
        return null;
    }

    public String getDefaultAuthMechanism() {
        return "NONE";
    }

    public abstract boolean isEvalSupported();

    public abstract String getDatabaseType();

    private boolean isShowAllDatabases() {
        DBPConnectionConfiguration configuration = this.getContainer().getActualConnectionConfiguration();
        if (CommonUtils.getBoolean((String)configuration.getProperty("showAllDatabases"), (boolean)true)) {
            return true;
        }
        return CommonUtils.isEmpty((String)this.getDatabaseName());
    }

    @NotNull
    private String getDatabaseName() {
        DBPConnectionConfiguration configuration = this.getContainer().getActualConnectionConfiguration();
        String name = MGUtils.getDatabaseFromURL(configuration.getUrl());
        if (CommonUtils.isNotEmpty((String)name)) {
            return name;
        }
        return configuration.getDatabaseName();
    }

    @Association
    public boolean supportsAdministrationInfo() {
        return true;
    }

    public boolean supportsCollectionRename() {
        return true;
    }

    class DatabaseCache
    extends BasicObjectCache<MGDataSource, MGDatabase> {
        DatabaseCache() {
        }

        @NotNull
        public List<MGDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGDatabase> databaseList = new ArrayList<MGDatabase>();
                if (!MGDataSource.this.isShowAllDatabases()) {
                    databaseList.add(new MGDatabase(dataSource, MGDataSource.this.getDatabaseName()));
                } else {
                    try {
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try (MGSession session = (MGSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)MGDataSource.this, (String)"Read databases");){
                            MongoIterable databaseNames = session.getExecutionContext().getClient().listDatabaseNames();
                            for (String dbName : databaseNames) {
                                MGDatabase db = new MGDatabase(dataSource, dbName);
                                databaseList.add(db);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        assert (dataSource != null);
                        databaseList.add(new MGDatabase(dataSource, MGDataSource.this.getDatabaseName()));
                    }
                }
                this.setCache(databaseList);
            }
            return this.getCachedObjects();
        }
    }
}

