/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.bson.BsonNull;
import org.bson.BsonRegularExpression;
import org.bson.Document;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class MongoSQLUtils {
    public static final String OPER_NE = "$ne";
    public static final String OPER_EQ = "$eq";
    public static final String OPER_GT = "$gt";
    public static final String OPER_GTE = "$gte";
    public static final String OPER_LT = "$lt";
    public static final String OPER_LTE = "$lte";
    public static final String OPER_REGEX = "$regex";
    public static final String OPER_IN = "$in";
    public static final String OPER_NOT = "$not";
    public static final String OPER_EXISTS = "$exists";
    public static final String OPER_AND = "$and";
    public static final String OPER_OR = "$or";
    private static final Log log = Log.getLog(MongoSQLUtils.class);

    public static Object normalizeMongoValue(MGDataSource dataSource, Object o) {
        if (o instanceof Map) {
            MongoSQLUtils.normalizeDocument(dataSource, (Map)o);
        } else if (o instanceof List) {
            MongoSQLUtils.normalizeDocument(dataSource, (List)o);
        }
        return o;
    }

    public static void normalizeDocument(MGDataSource dataSource, Map<String, Object> o) {
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (entry.getValue() instanceof Decimal128 && !dataSource.supportsDecimal128()) {
                entry.setValue(((Decimal128)entry.getValue()).doubleValue());
                continue;
            }
            if (!(entry.getValue() instanceof DBObject)) continue;
            MongoSQLUtils.normalizeMongoValue(dataSource, (DBObject)entry.getValue());
        }
    }

    public static void normalizeDocument(MGDataSource dataSource, List<Object> o) {
        for (Object item : o) {
            if (!(item instanceof DBObject)) continue;
            MongoSQLUtils.normalizeMongoValue(dataSource, (DBObject)item);
        }
    }

    @Nullable
    public static Document makeQueryFromFilter(@NotNull MGDataSource dataSource, @Nullable DBDDataFilter filter) throws DBCException {
        if (filter == null || !filter.hasConditions()) {
            return null;
        }
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)condString, (boolean)true);
        Expression expr = SQLSemanticProcessor.parseCondExpression((String)condString.toString());
        return MongoSQLUtils.convertExpressionToObject(expr);
    }

    @NotNull
    public static String makeSQLQuery(@NotNull MGCollection collection, @Nullable DBDDataFilter filter) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (filter != null && filter.hasConditions()) {
            sql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            sql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (boolean)false, (StringBuilder)sql);
        }
        return sql.toString();
    }

    public static Document convertExpressionToObject(Expression expression) throws DBCException {
        Document object = new Document();
        MongoSQLUtils.parseExpression(object, expression);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void parseExpression(Document owner, Expression expr) throws DBCException {
        Expression expression = expr;
        if (expression instanceof AndExpression) {
            void andExpression;
            AndExpression andExpression2 = (AndExpression)expression;
            AndExpression cfr_ignored_0 = (AndExpression)expression;
            BasicDBList list = new BasicDBList();
            list.add((Object)MongoSQLUtils.convertExpressionToObject(andExpression.getLeftExpression()));
            list.add((Object)MongoSQLUtils.convertExpressionToObject(andExpression.getRightExpression()));
            owner.put(OPER_AND, (Object)list);
        } else {
            Expression expression2 = expr;
            if (expression2 instanceof OrExpression) {
                void orExpression;
                OrExpression list = (OrExpression)expression2;
                OrExpression cfr_ignored_1 = (OrExpression)expression2;
                BasicDBList list2 = new BasicDBList();
                list2.add((Object)MongoSQLUtils.convertExpressionToObject(orExpression.getLeftExpression()));
                list2.add((Object)MongoSQLUtils.convertExpressionToObject(orExpression.getRightExpression()));
                owner.put(OPER_OR, (Object)list2);
            } else {
                Expression expression3 = expr;
                if (expression3 instanceof InExpression) {
                    void itemsList;
                    void column;
                    void inExpression;
                    Expression leftExpression;
                    InExpression list2 = (InExpression)expression3;
                    InExpression cfr_ignored_2 = (InExpression)expression3;
                    Expression expression4 = leftExpression = inExpression.getLeftExpression();
                    if (!(expression4 instanceof Column)) {
                        throw new DBCException("IN conditions mast have column on the left side");
                    }
                    Column column2 = (Column)expression4;
                    Column cfr_ignored_3 = (Column)expression4;
                    ItemsList itemsList2 = ((InExpression)expr).getRightItemsList();
                    if (!(itemsList2 instanceof ExpressionList)) {
                        throw new DBCException("IN conditions mast have expression list on the right side");
                    }
                    ExpressionList expressionList = (ExpressionList)itemsList2;
                    ExpressionList cfr_ignored_4 = (ExpressionList)itemsList2;
                    String fieldName = MongoSQLUtils.unquote(column.getFullyQualifiedName());
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (Expression exp : itemsList.getExpressions()) {
                        Object fieldValue = MongoSQLUtils.parseValueExpression(exp);
                        values.add(fieldValue);
                    }
                    MongoSQLUtils.makeObjectCondition(owner, fieldName, values, OPER_IN);
                } else {
                    Expression expression5 = expr;
                    if (expression5 instanceof Between) {
                        void column;
                        void between;
                        Expression left;
                        Between leftExpression = (Between)expression5;
                        Between cfr_ignored_5 = (Between)expression5;
                        Expression expression6 = left = between.getLeftExpression();
                        if (!(expression6 instanceof Column)) {
                            throw new DBCException("Unsupported left operand: " + String.valueOf(left));
                        }
                        Column itemsList = (Column)expression6;
                        Column cfr_ignored_6 = (Column)expression6;
                        String columnName = MongoSQLUtils.unquote(column.getFullyQualifiedName());
                        BasicDBObject columnRange = new BasicDBObject();
                        columnRange.put((Object)OPER_GTE, MongoSQLUtils.parseValueExpression(between.getBetweenExpressionStart()));
                        columnRange.put((Object)OPER_LTE, MongoSQLUtils.parseValueExpression(between.getBetweenExpressionEnd()));
                        owner.put(columnName, (Object)columnRange);
                    } else {
                        Expression expression7 = expr;
                        if (expression7 instanceof BinaryExpression) {
                            void binaryExpression;
                            BinaryExpression left = (BinaryExpression)expression7;
                            BinaryExpression cfr_ignored_7 = (BinaryExpression)expression7;
                            MongoSQLUtils.parseBinaryExpression(owner, (BinaryExpression)binaryExpression);
                        } else {
                            Expression expression8 = expr;
                            if (expression8 instanceof Parenthesis) {
                                void parenthesis;
                                Parenthesis parenthesis2 = (Parenthesis)expression8;
                                Parenthesis cfr_ignored_8 = (Parenthesis)expression8;
                                MongoSQLUtils.parseExpression(owner, parenthesis.getExpression());
                            } else {
                                Expression expression9 = expr;
                                if (expression9 instanceof IsNullExpression) {
                                    void column;
                                    Expression left;
                                    void isNullExpression;
                                    IsNullExpression exp = (IsNullExpression)expression9;
                                    IsNullExpression cfr_ignored_9 = (IsNullExpression)expression9;
                                    boolean not = isNullExpression.isNot();
                                    Expression expression10 = left = isNullExpression.getLeftExpression();
                                    if (!(expression10 instanceof Column)) {
                                        throw new DBCException("Unsupported left operand: " + String.valueOf(left));
                                    }
                                    Column column3 = (Column)expression10;
                                    Column cfr_ignored_10 = (Column)expression10;
                                    owner.put(MongoSQLUtils.unquote(column.getFullyQualifiedName()), (Object)new BasicDBObject(not ? OPER_NE : OPER_EQ, (Object)BsonNull.VALUE));
                                } else {
                                    throw new DBCException("Unsupported expression: " + String.valueOf(expr));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseBinaryExpression(Document owner, BinaryExpression expr) throws DBCException {
        String operator;
        void column;
        Expression left = expr.getLeftExpression();
        Expression expression = left;
        if (!(expression instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + String.valueOf(left));
        }
        Column column2 = (Column)expression;
        Column cfr_ignored_0 = (Column)expression;
        String fieldName = MongoSQLUtils.unquote(column.getFullyQualifiedName());
        Object fieldValue = MongoSQLUtils.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = null;
        } else if (expr instanceof NotEqualsTo) {
            operator = OPER_NE;
        } else if (expr instanceof GreaterThan) {
            operator = OPER_GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = OPER_GTE;
        } else if (expr instanceof MinorThan) {
            operator = OPER_LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = OPER_LTE;
        } else if (expr instanceof LikeExpression) {
            LikeExpression like = (LikeExpression)expr;
            operator = like.isNot() ? OPER_NOT : OPER_REGEX;
            fieldValue = MongoSQLUtils.makeRegexFromLike((String)fieldValue, like.isCaseInsensitive() ? "i" : null);
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        MongoSQLUtils.makeObjectCondition(owner, fieldName, fieldValue, operator);
    }

    /*
     * WARNING - void declaration
     */
    private static void makeObjectCondition(Document owner, String fieldName, Object fieldValue, String operator) {
        Object value;
        fieldValue = MongoSQLUtils.getFieldValueOrID(fieldName, fieldValue);
        if (operator == null) {
            value = fieldValue;
        } else {
            Object object = fieldValue;
            if (object instanceof List) {
                void list;
                List list2 = (List)object;
                List cfr_ignored_0 = (List)object;
                BasicDBList dbList = new BasicDBList();
                for (Object item : list) {
                    item = MongoSQLUtils.getFieldValueOrID(fieldName, item);
                    dbList.add(item);
                }
                value = new BasicDBObject(operator, (Object)dbList);
            } else {
                value = new BasicDBObject(operator, fieldValue);
                if (operator.equals(OPER_NE) || operator.equals(OPER_NOT)) {
                    ((DBObject)value).put(OPER_EXISTS, (Object)true);
                }
            }
        }
        owner.put(fieldName, value);
    }

    /*
     * WARNING - void declaration
     */
    private static Object getFieldValueOrID(String fieldName, Object fieldValue) {
        Object object;
        if (fieldName.equals("_id") && (object = fieldValue) instanceof String) {
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            try {
                void str;
                fieldValue = new ObjectId((String)str);
            }
            catch (Exception exception) {}
        }
        return fieldValue;
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = MongoSQLUtils.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + String.valueOf(expr));
        }
        if (expr instanceof Function) {
            String funcName = ((Function)expr).getName();
            ExpressionList parameters = ((Function)expr).getParameters();
            if ("ObjectId".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ObjectId must have 1 parameter");
                }
                return new ObjectId(CommonUtils.toString((Object)MongoSQLUtils.parseValueExpression((Expression)parameters.getExpressions().get(0))));
            }
            if ("ISODate".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ISODate must have 1 parameter");
                }
                return JSONUtils.parseDate((Object)MongoSQLUtils.parseValueExpression((Expression)parameters.getExpressions().get(0)));
            }
            throw new DBCException("Unsupported function: " + funcName);
        }
        if (expr instanceof SignedExpression) {
            Object value = MongoSQLUtils.parseValueExpression(((SignedExpression)expr).getExpression());
            char sign = ((SignedExpression)expr).getSign();
            if (value instanceof Long) {
                if (sign == '-') {
                    return -((Long)value).longValue();
                }
                if (sign == '+') {
                    return value;
                }
            } else if (value instanceof Double) {
                if (sign == '-') {
                    return -((Double)value).doubleValue();
                }
                if (sign == '+') {
                    return value;
                }
            }
        }
        throw new DBCException("Unsupported value: " + String.valueOf(expr));
    }

    private static BsonRegularExpression makeRegexFromLike(String clause, String options) {
        return new BsonRegularExpression(SQLUtils.makeRegexFromLike((String)clause), options);
    }

    public static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }

    public static Object convertValueExpressionToObject(Expression expression) throws DBCException {
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof DateValue) {
            return ((DateValue)expression).getValue();
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        if (expression instanceof Column) {
            String string = expression.toString();
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            return string;
        }
        return expression.toString();
    }
}

