/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGCursor;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.client.FindIterable;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;

public class MGSelectStatement
extends MGBaseStatement {
    @Nullable
    private final DBDDataFilter dataFilter;

    public MGSelectStatement(@NotNull MGSession mongoSession, @NotNull MGCollection collection, @Nullable DBDDataFilter dataFilter) {
        super(mongoSession, MongoSQLUtils.makeSQLQuery(collection, dataFilter));
        this.collection = collection;
        this.dataFilter = dataFilter;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            Document ref = MongoSQLUtils.makeQueryFromFilter(((MGSession)this.getSession()).getDataSource(), this.dataFilter);
            this.result = new MGCursor((FindIterable<Document>)(ref == null ? this.collection.getMongoCollection((MGSession)this.getSession()).find() : this.collection.getMongoCollection((MGSession)this.getSession()).find((Bson)ref)));
            if (this.dataFilter != null && this.dataFilter.hasOrdering()) {
                Document order = new Document();
                for (DBDAttributeConstraint constr : this.dataFilter.getOrderConstraints()) {
                    String name = MongoSQLUtils.unquote(constr.getFullAttributeName());
                    order.put(name, (Object)(constr.isOrderDescending() ? -1 : 1));
                }
                this.result.sort(order);
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

