/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MGInsertStatement
extends MGBaseStatement {
    private final DBSAttributeBase[] valueAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();
    private int[] batchResult;

    public MGInsertStatement(MGSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, MGInsertStatement.makeQuery(mongoCollection, updateAttributes, rowValues));
        this.collection = mongoCollection;
        this.valueAttributes = updateAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    @Override
    public void addToBatch() throws DBCException {
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        this.executeStatement();
        return this.batchResult;
    }

    /*
     * Unable to fully structure code
     */
    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            this.batchResult = new int[this.rowValues.size()];
            newDocs = new ArrayList<Document>();
            for (Object[] row : this.rowValues) {
                block10: {
                    block9: {
                        if (this.valueAttributes.length != 1 || this.valueAttributes[0].getDataKind() != DBPDataKind.DOCUMENT) break block9;
                        o = (Document)MGUtils.unwrapMongoValue(((MGSession)this.getSession()).getDataSource(), this.valueAttributes[0], ((DBDDocument)row[0]).getRootNode());
                        this.convertObjectIdAttributes(o);
                        break block10;
                    }
                    o = new Document();
                    i = 0;
                    while (i < this.valueAttributes.length) {
                        attrName = MongoSQLUtils.unquote(this.collection.getAttributeName(this.valueAttributes[i]));
                        attrName = attrName.replace(".", "_");
                        var10_10 = row[i];
                        if (!(var10_10 instanceof String)) ** GOTO lbl-1000
                        (String)var10_10;
                        (String)var10_10;
                        if (this.valueAttributes[i].getDataKind().equals((Object)DBPDataKind.ROWID)) {
                            attrValue = new ObjectId((String)rowId);
                        } else lbl-1000:
                        // 2 sources

                        {
                            attrValue = MGUtils.unwrapMongoValue(((MGSession)this.getSession()).getDataSource(), this.valueAttributes[i], row[i]);
                        }
                        o.put(attrName, attrValue);
                        ++i;
                    }
                }
                newDocs.add((Document)MongoSQLUtils.normalizeMongoValue(((MGSession)this.getSession()).getDataSource(), o));
            }
            this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).insertMany(newDocs).getInsertedIds().size();
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
            this.rowValues.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void convertObjectIdAttributes(Document o) {
        DBSAttributeBase dBSAttributeBase = this.valueAttributes[0];
        if (dBSAttributeBase instanceof DBDAttributeBindingMeta) {
            void meta;
            DBDAttributeBindingMeta dBDAttributeBindingMeta = (DBDAttributeBindingMeta)dBSAttributeBase;
            DBDAttributeBindingMeta cfr_ignored_0 = (DBDAttributeBindingMeta)dBSAttributeBase;
            if (meta.getNestedBindings() == null) {
                return;
            }
            for (Map.Entry entry : o.entrySet()) {
                for (DBDAttributeBinding nestedBinding : meta.getNestedBindings()) {
                    String docId;
                    void attributeBindingType;
                    DBDAttributeBinding dBDAttributeBinding = nestedBinding;
                    if (!(dBDAttributeBinding instanceof DBDAttributeBindingType)) continue;
                    DBDAttributeBindingType cfr_ignored_1 = (DBDAttributeBindingType)dBDAttributeBinding;
                    DBDAttributeBindingType cfr_ignored_2 = (DBDAttributeBindingType)dBDAttributeBinding;
                    if (!((String)entry.getKey()).equals(attributeBindingType.getName()) || !attributeBindingType.getDataKind().equals((Object)DBPDataKind.ROWID) || !(entry.getValue() instanceof String)) continue;
                    String stringId = String.valueOf(entry.getValue());
                    try {
                        docId = new ObjectId(stringId);
                    }
                    catch (Exception exception) {
                        docId = stringId;
                    }
                    entry.setValue(docId);
                }
            }
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO  ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i]));
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }
}

