/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSCursor;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoNamespace;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.RuntimeAction;

public class MongoJSCollection
extends AbstractMap<String, Object> {
    private static final Log log = Log.getLog(MongoJSCollection.class);
    private final MongoJSDatabase database;
    private final MGCollection collection;

    public MongoJSCollection(MongoJSDatabase database, MGCollection collection) {
        this.database = database;
        this.collection = collection;
    }

    @Nullable
    private ClientSession getClientSession() {
        return this.getMongoSession().getClientSession();
    }

    @NotNull
    private MGSession getMongoSession() {
        return this.database.getProcessor().getSession();
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return ((Object)((Object)this.collection)).hashCode();
    }

    @NotNull
    private MongoCollection<Document> getMongoCollection() throws DBCException {
        return this.collection.getMongoCollection(this.getMongoSession());
    }

    public Object insert(Map<String, Object> document) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().insertOne((Object)MongoJSUtils.createBasicDocument(MongoJSUtils.unwrapMap(document)));
        }
        this.getMongoCollection().insertOne(clientSession, (Object)MongoJSUtils.createDocument(document));
        return "Inserted 1 document";
    }

    public Object insert(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().insertMany(MongoJSUtils.createBasicList(documents));
        }
        this.getMongoCollection().insertMany(clientSession, MongoJSUtils.createDocumentList(documents));
        return "Inserted " + documents.size() + " document(s)";
    }

    public Object save(Map<String, Object> document) throws DBCException {
        return this.getMongoCollection().insertOne((Object)MongoJSUtils.createBasicDocument(document));
    }

    public Object update(Map<String, Object> query, Map<String, Object> update, boolean upsert) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(query), (Bson)MongoJSUtils.createBasicDocument(update), new UpdateOptions().upsert(upsert));
    }

    public UpdateResult update(Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(query), (Bson)MongoJSUtils.createBasicDocument(update));
    }

    public DeleteResult remove(Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().deleteOne((Bson)MongoJSUtils.createBasicDocument(query));
    }

    public DeleteResult delete(Map<String, Object> query) throws DBCException {
        return this.remove(query);
    }

    public MongoJSCursor find(Map<String, Object> query) throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)));
    }

    public MongoJSCursor find(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    public Iterable<Document> aggregate(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getMongoCollection().aggregate(MongoJSUtils.createBasicList(documents));
        }
        return this.getMongoCollection().aggregate(clientSession, MongoJSUtils.createDocumentList(documents)).map(Document::new);
    }

    private Document getOne(FindIterable<Document> i) {
        i.limit(1);
        MongoCursor iterator = i.iterator();
        return iterator.hasNext() ? (Document)iterator.next() : null;
    }

    public MongoJSCursor find() throws DBCException {
        return new MongoJSCursor((FindIterable<Document>)this.getMongoCollection().find());
    }

    @Nullable
    public Document findOne() throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find());
    }

    @Nullable
    public Document findOne(Map<String, Object> query) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)));
    }

    @Nullable
    public Document findOne(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    @Nullable
    public Document findOne(Map<String, Object> query, Map<String, Object> projection, Map<String, Object> sort) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)MongoJSUtils.createBasicDocument(query)).projection((Bson)MongoJSUtils.createBasicDocument(projection)).sort((Bson)MongoJSUtils.createBasicDocument(sort)));
    }

    @Nullable
    public Document findOne(Object id) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)new Document("_id", id)));
    }

    @Nullable
    public Document findOne(Object id, Map<String, Object> projection) throws DBCException {
        return this.getOne((FindIterable<Document>)this.getMongoCollection().find((Bson)new Document("_id", id)).projection((Bson)MongoJSUtils.createBasicDocument(projection)));
    }

    public long count() throws DBCException {
        return this.getMongoCollection().countDocuments();
    }

    public long count(@Nullable Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().countDocuments((Bson)MongoJSUtils.createBasicDocument(query));
    }

    public long countDocuments() throws DBCException {
        return this.count();
    }

    public long countDocuments(@Nullable Map<String, Object> query) throws DBCException {
        return this.count(query);
    }

    public Object rename(String newName) throws DBCException {
        this.getMongoCollection().renameCollection(new MongoNamespace(newName));
        return this;
    }

    public MongoJSCollection rename(String newName, boolean dropTarget) throws DBCException {
        this.getMongoCollection().renameCollection(new MongoNamespace(newName), new RenameCollectionOptions().dropTarget(dropTarget));
        return this;
    }

    public long deleteOne(Map<String, Object> filter) throws DBCException {
        return this.getMongoCollection().deleteOne((Bson)MongoJSUtils.createBasicDocument(filter)).getDeletedCount();
    }

    public long deleteMany(Map<String, Object> filter) throws DBCException {
        return this.getMongoCollection().deleteMany((Bson)MongoJSUtils.createBasicDocument(filter)).getDeletedCount();
    }

    public long updateOne(Map<String, Object> filter, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateOne((Bson)MongoJSUtils.createBasicDocument(filter), (Bson)MongoJSUtils.createBasicDocument(update)).getModifiedCount();
    }

    public long updateMany(Map<String, Object> filter, Map<String, Object> update) throws DBCException {
        return this.getMongoCollection().updateMany((Bson)MongoJSUtils.createBasicDocument(filter), (Bson)MongoJSUtils.createBasicDocument(update)).getModifiedCount();
    }

    public void drop() throws DBCException {
        this.getMongoCollection().drop();
    }

    public MongoCursor<Object> distinct(String fieldName) throws DBCException {
        return this.getMongoCollection().distinct(fieldName, Object.class).iterator();
    }

    public MongoCursor<Object> distinct(String fieldName, Map<String, Object> query) throws DBCException {
        return this.getMongoCollection().distinct(fieldName, (Bson)MongoJSUtils.createBasicDocument(query), Object.class).iterator();
    }

    public String getName() throws DBCException {
        return this.getMongoCollection().getNamespace().getCollectionName();
    }

    public String getFullName() throws DBCException {
        return this.getMongoCollection().getNamespace().getFullName();
    }

    public Object getMongoCollection(String name) {
        return this.database.get(name);
    }

    public void createIndex(String name) throws DBCException {
        this.getMongoCollection().createIndex((Bson)new BasicDBObject(name, (Object)1));
    }

    public void createIndex(Map<String, Object> keys, String name) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys), new IndexOptions().name(name));
    }

    public void createIndex(Map<String, Object> keys, @Nullable String name, boolean unique) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys), new IndexOptions().name(name).unique(unique));
    }

    public void createIndex(Map<String, Object> keys) throws DBCException {
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys));
    }

    public void createIndex(Map<String, Object> keys, Map<String, Object> options) throws DBCException {
        Object wildcardProjectionValue;
        Object bucketSizeValue;
        Object minValue;
        Object bitsValue;
        Object textIndexVersionValue;
        Object languageOverrideValue;
        Object defaultLanguageValue;
        Object weightsValue;
        Object collationValue;
        Object storageEngineValue;
        Object hiddenValue;
        Object expireAfterSecondsValue;
        Object sparseValue;
        Object partialFilterExpressionValue;
        Object nameValue;
        IndexOptions indexOptions = new IndexOptions();
        Object uniqueValue = options.get("unique");
        if (uniqueValue != null) {
            indexOptions.unique(((Boolean)uniqueValue).booleanValue());
        }
        if ((nameValue = options.get("name")) != null) {
            indexOptions.name((String)nameValue);
        }
        if ((partialFilterExpressionValue = options.get("partialFilterExpression")) != null) {
            indexOptions.partialFilterExpression((Bson)MongoJSUtils.createBasicDocument((Map)partialFilterExpressionValue));
        }
        if ((sparseValue = options.get("sparse")) != null) {
            indexOptions.sparse(((Boolean)sparseValue).booleanValue());
        }
        if ((expireAfterSecondsValue = options.get("expireAfterSeconds")) != null) {
            indexOptions.expireAfter((Long)expireAfterSecondsValue, TimeUnit.SECONDS);
        }
        if ((hiddenValue = options.get("hidden")) != null) {
            indexOptions.hidden(((Boolean)hiddenValue).booleanValue());
        }
        if ((storageEngineValue = options.get("storageEngine")) != null) {
            indexOptions.storageEngine((Bson)MongoJSUtils.createBasicDocument((Map)storageEngineValue));
        }
        if ((collationValue = options.get("collation")) != null) {
            Object backwardsValue;
            Object maxVariableValue;
            Object alternateValue;
            Object numericOrderingValue;
            Object strengthValue;
            Object caseFirstValue;
            Object caseLevelValue;
            Map collation = (Map)collationValue;
            Collation.Builder builder = Collation.builder();
            Object localeValue = collation.get("locale");
            if (localeValue != null) {
                builder.locale((String)localeValue);
            }
            if ((caseLevelValue = collation.get("caseLevel")) != null) {
                builder.caseLevel((Boolean)caseLevelValue);
            }
            if ((caseFirstValue = collation.get("caseFirst")) != null) {
                builder.collationCaseFirst(CollationCaseFirst.fromString((String)((String)caseFirstValue)));
            }
            if ((strengthValue = collation.get("strength")) != null) {
                builder.collationStrength(CollationStrength.fromInt((int)((Integer)strengthValue)));
            }
            if ((numericOrderingValue = collation.get("numericOrdering")) != null) {
                builder.numericOrdering((Boolean)numericOrderingValue);
            }
            if ((alternateValue = collation.get("alternate")) != null) {
                builder.collationAlternate(CollationAlternate.fromString((String)((String)alternateValue)));
            }
            if ((maxVariableValue = collation.get("maxVariable")) != null) {
                builder.collationMaxVariable(CollationMaxVariable.fromString((String)((String)maxVariableValue)));
            }
            if ((backwardsValue = collation.get("backwards")) != null) {
                builder.backwards((Boolean)backwardsValue);
            }
            indexOptions.collation(builder.build());
        }
        if ((weightsValue = options.get("weights")) != null) {
            indexOptions.weights((Bson)MongoJSUtils.createBasicDocument((Map)weightsValue));
        }
        if ((defaultLanguageValue = options.get("default_language")) != null) {
            indexOptions.defaultLanguage((String)defaultLanguageValue);
        }
        if ((languageOverrideValue = options.get("language_override")) != null) {
            indexOptions.languageOverride((String)languageOverrideValue);
        }
        if ((textIndexVersionValue = options.get("textIndexVersion")) != null) {
            indexOptions.textVersion((Integer)textIndexVersionValue);
        }
        if ((bitsValue = options.get("bits")) != null) {
            indexOptions.bits((Integer)bitsValue);
        }
        if ((minValue = options.get("min")) != null) {
            indexOptions.min((Double)minValue);
        }
        if ((bucketSizeValue = options.get("bucketSize")) != null) {
            indexOptions.bucketSize((Double)bucketSizeValue);
        }
        if ((wildcardProjectionValue = options.get("wildcardProjection")) != null) {
            indexOptions.wildcardProjection((Bson)MongoJSUtils.createBasicDocument((Map)wildcardProjectionValue));
        }
        this.getMongoCollection().createIndex((Bson)MongoJSUtils.createBasicDocument(keys), indexOptions);
    }

    public MongoCursor<Document> getIndexInfo() throws DBCException {
        return this.getMongoCollection().listIndexes().iterator();
    }

    public MongoCursor<Document> listIndexes() throws DBCException {
        return this.getMongoCollection().listIndexes().iterator();
    }

    public void dropIndex(Map<String, Object> index) throws DBCException {
        this.getMongoCollection().dropIndex((Bson)MongoJSUtils.createBasicDocument(index));
    }

    public void dropIndex(String indexName) throws DBCException {
        this.getMongoCollection().dropIndex(indexName);
    }

    public void dropIndexes() throws DBCException {
        this.getMongoCollection().dropIndexes();
    }

    @RuntimeAction
    public Map<String, Object> getStats() throws DBCException {
        return this.database.runCommand(Map.of("collStats", this.getName()));
    }

    @RuntimeAction
    public Map<String, Object> stats() throws DBCException {
        return this.getStats();
    }

    @Nullable
    public Document findAndModify(@Nullable Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return (Document)this.getMongoCollection().findOneAndUpdate((Bson)(query == null ? null : MongoJSUtils.createBasicDocument(query)), (Bson)MongoJSUtils.createBasicDocument(update));
    }

    @Nullable
    public Document findAndRemove(@Nullable Map<String, Object> query) throws DBCException {
        return (Document)this.getMongoCollection().findOneAndDelete((Bson)(query == null ? null : MongoJSUtils.createBasicDocument(query)));
    }

    public long totalSize() throws DBCException {
        return 0L;
    }
}

