/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data.handlers;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.data.MGListValue;
import com.dbeaver.db.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MGCustomStatement;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.document.data.DBDocumentElement;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDComplexValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoDocumentValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoDocumentValueHandler INSTANCE = new MongoDocumentValueHandler();

    @NotNull
    public Class<DBObject> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBObject.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBObject || value instanceof DBDComplexValue) {
            return value.toString();
        }
        return "#document";
    }

    /*
     * WARNING - void declaration
     */
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new MGDocument((MGDataSource)session.getDataSource(), new Document());
        }
        if (object instanceof Document) {
            if (copy) {
                object = MGUtils.cloneObject(object);
            }
            return new MGDocument((MGDataSource)session.getDataSource(), (Document)object);
        }
        Object object2 = object;
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            Map cfr_ignored_0 = (Map)object2;
            return new MGDocument((MGDataSource)session.getDataSource(), new Document(MongoDocumentValueHandler.convertMapToDocumentFormat((Map)object)));
        }
        Object object3 = object;
        if (object3 instanceof MGDocument) {
            void srcDocument;
            MGDocument mGDocument = (MGDocument)((Object)object3);
            MGDocument cfr_ignored_1 = (MGDocument)((Object)object3);
            return new MGDocument((MGDataSource)srcDocument.getDataSource(), (Document)MGUtils.cloneObject(srcDocument.getRawValue()));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Object, Object> convertMapToDocumentFormat(Map<Object, Object> objectMap) {
        LinkedHashMap<Object, Object> objectObjectHashMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> objectEntry : objectMap.entrySet()) {
            Object value = objectEntry.getValue();
            Object object = value;
            if (object instanceof DBDocumentElement) {
                void wrapper;
                DBDocumentElement cfr_ignored_0 = (DBDocumentElement)object;
                DBDocumentElement cfr_ignored_1 = (DBDocumentElement)object;
                value = wrapper.objectValue();
            }
            objectObjectHashMap.put(objectEntry.getKey(), value);
        }
        return objectObjectHashMap;
    }

    @Override
    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object columnValue = super.fetchValueObject(session, resultSet, type, index);
        if (columnValue instanceof BasicDBList) {
            Document map = new Document("", columnValue);
            columnValue = map;
        }
        return new MGDocument((MGDataSource)session.getDataSource(), (Document)columnValue);
    }

    @Override
    protected void bindParameter(MGSession session, MGCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        if (type.getDataKind() == DBPDataKind.ARRAY) {
            return new MGListValue((MGDataSource)session.getDataSource(), (List<Object>)new BasicDBList());
        }
        Document emptyDocument = new Document();
        emptyDocument.put("_id", (Object)new ObjectId());
        return new MGDocument((MGDataSource)session.getDataSource(), emptyDocument);
    }
}

