/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.translator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SimpleFilterManager
implements QMTranslationHistoryManager {
    private static final Map<String, List<QMTranslationHistoryItem>> queryHistory = new HashMap<String, List<QMTranslationHistoryItem>>();

    @NotNull
    public List<QMTranslationHistoryItem> readTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, int maxCount) {
        List<QMTranslationHistoryItem> queries = queryHistory.get(dataSource.getDataSourceContainer().getId());
        if (!CommonUtils.isEmpty(queries)) {
            return new ArrayList<QMTranslationHistoryItem>(queries);
        }
        return Collections.emptyList();
    }

    public void saveTranslationHistory(@NotNull DBRProgressMonitor monitor, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull String natualText, @NotNull String sqlText) {
        List queries = queryHistory.computeIfAbsent(dataSource.getDataSourceContainer().getId(), k -> new ArrayList());
        QMTranslationHistoryItem item = new QMTranslationHistoryItem(natualText, sqlText);
        item.setTime(new Date());
        queries.add(item);
    }
}

