/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.openai;

import java.util.Arrays;
import java.util.Optional;
import org.jkiss.code.NotNull;

public enum GPTModel {
    GPT_TURBO("gpt-3.5-turbo", 4096, true),
    GPT_TURBO16("gpt-3.5-turbo-16k", 16384, true),
    GPT_TURBO_INSTRUCT("gpt-3.5-turbo-instruct", 4096, false),
    GPT_4("gpt-4", 8192, true),
    TEXT_ADA("text-ada-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_CURIE("text-curie-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_BABBAGE("text-babbage-001", 2048, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI01("text-davinci-003", 4096, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI02("text-davinci-002", 4096, false, GPT_TURBO_INSTRUCT),
    TEXT_DAVINCI03("text-davinci-001", 2048, false, GPT_TURBO_INSTRUCT);

    private final String name;
    private final int maxTokens;
    private final boolean isChatAPI;
    private GPTModel deprecationReplacementModel = null;

    @NotNull
    public static GPTModel getByName(@NotNull String name) {
        Optional<GPTModel> model = Arrays.stream(GPTModel.values()).filter(it -> it.name.equals(name)).findFirst();
        GPTModel gptModel = model.orElse(GPT_TURBO16);
        if (gptModel.getDeprecationReplacementModel() != null) {
            return gptModel.getDeprecationReplacementModel();
        }
        return gptModel;
    }

    private GPTModel(String name, int maxTokens, boolean isChatAPI) {
        this.name = name;
        this.maxTokens = maxTokens;
        this.isChatAPI = isChatAPI;
    }

    private GPTModel(String name, int maxTokens, boolean isChatAPI, GPTModel deprecationReplacementModel) {
        this.name = name;
        this.maxTokens = maxTokens;
        this.isChatAPI = isChatAPI;
        this.deprecationReplacementModel = deprecationReplacementModel;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public boolean isChatAPI() {
        return this.isChatAPI;
    }

    public String getName() {
        return this.name;
    }

    public GPTModel getDeprecationReplacementModel() {
        return this.deprecationReplacementModel;
    }
}

