/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.metadata;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;

public class MetadataProcessor {
    public static final MetadataProcessor INSTANCE = new MetadataProcessor();
    private static final Log log = Log.getLog(MetadataProcessor.class);
    private static final boolean SUPPORTS_ATTRS = true;

    /*
     * WARNING - void declaration
     */
    public String generateObjectDescription(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @Nullable DBCExecutionContext context, @NotNull IAIFormatter formatter, int maxRequestLength, boolean useFullyQualifiedName) throws DBException {
        if (DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)object, (boolean)false) == null) {
            return "";
        }
        StringBuilder description = new StringBuilder();
        DBSObject dBSObject = object;
        if (dBSObject instanceof DBSEntity) {
            void entity;
            DBSEntity dBSEntity = (DBSEntity)dBSObject;
            DBSEntity cfr_ignored_0 = (DBSEntity)dBSObject;
            String name = useFullyQualifiedName && context != null ? DBUtils.getObjectFullName((DBPDataSource)context.getDataSource(), (DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier((DBSObject)object);
            description.append('\n');
            formatter.addObjectDescriptionIfNeeded(description, (DBPObjectWithDescription)object, monitor);
            DBSObject dBSObject2 = object;
            if (dBSObject2 instanceof DBSTable) {
                void table;
                DBSTable dBSTable = (DBSTable)dBSObject2;
                DBSTable cfr_ignored_1 = (DBSTable)dBSObject2;
                description.append(table.isView() ? "CREATE VIEW" : "CREATE TABLE");
            }
            description.append(" ").append(name).append("(");
            DBSEntityAttribute firstAttr = this.addPromptAttributes(monitor, (DBSEntity)entity, description, formatter);
            formatter.addExtraDescription(monitor, (DBSEntity)entity, description, (DBPObjectWithDescription)firstAttr);
            description.append(");");
        } else {
            DBSObject dBSObject3 = object;
            if (dBSObject3 instanceof DBSObjectContainer) {
                void objectContainer;
                DBSObjectContainer name = (DBSObjectContainer)dBSObject3;
                DBSObjectContainer cfr_ignored_2 = (DBSObjectContainer)dBSObject3;
                monitor.subTask("Load cache of " + object.getName());
                objectContainer.cacheStructure(monitor, 3);
                for (DBSObject child : objectContainer.getChildren(monitor)) {
                    if (DBUtils.isSystemObject((Object)child) || DBUtils.isHiddenObject((Object)child) || child instanceof DBSTablePartition) continue;
                    String childText = this.generateObjectDescription(monitor, child, context, formatter, maxRequestLength, this.isRequiresFullyQualifiedName(child, context));
                    if (description.length() + childText.length() > maxRequestLength * 3) {
                        log.debug((Object)("Trim AI metadata prompt  at table '" + child.getName() + "' - too long request"));
                        break;
                    }
                    description.append(childText);
                }
            }
        }
        return description.toString();
    }

    @NotNull
    public DAICompletionMessage createMetadataMessage(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @Nullable DBSObjectContainer mainObject, @NotNull IAIFormatter formatter, @NotNull String instructions, int maxRequestTokens) throws DBException {
        DBSSchema defaultSchema;
        if (mainObject == null || mainObject.getDataSource() == null) {
            throw new DBException("Invalid completion request");
        }
        DBCExecutionContext executionContext = context.getExecutionContext();
        StringBuilder sb = new StringBuilder(instructions);
        String extraInstructions = formatter.getExtraInstructions(monitor, mainObject, executionContext);
        if (CommonUtils.isNotEmpty((String)extraInstructions)) {
            sb.append(", ").append(extraInstructions);
        }
        sb.append("\nDialect is ").append(mainObject.getDataSource().getSQLDialect().getDialectName());
        if (executionContext.getContextDefaults() != null && (defaultSchema = executionContext.getContextDefaults().getDefaultSchema()) != null) {
            sb.append("\nCurrent schema is ").append(defaultSchema.getName());
        }
        sb.append("\nSQL tables, with their properties are:");
        int remainingRequestTokens = maxRequestTokens - sb.length() - 20;
        if (context.getScope() == DAICompletionScope.CUSTOM) {
            for (DBSEntity entity : context.getCustomEntities()) {
                sb.append(this.generateObjectDescription(monitor, (DBSObject)entity, executionContext, formatter, remainingRequestTokens, this.isRequiresFullyQualifiedName((DBSObject)entity, executionContext)));
            }
        } else {
            sb.append(this.generateObjectDescription(monitor, (DBSObject)mainObject, executionContext, formatter, remainingRequestTokens, false));
        }
        return new DAICompletionMessage(DAICompletionMessage.Role.SYSTEM, sb.toString());
    }

    protected DBSEntityAttribute addPromptAttributes(DBRProgressMonitor monitor, DBSEntity entity, StringBuilder prompt, IAIFormatter formatter) throws DBException {
        DBSEntityAttribute prevAttribute = null;
        List attributes = entity.getAttributes(monitor);
        if (attributes != null) {
            for (DBSEntityAttribute attribute : attributes) {
                if (DBUtils.isHiddenObject((Object)attribute)) continue;
                if (prevAttribute != null) {
                    prompt.append(",");
                    formatter.addObjectDescriptionIfNeeded(prompt, (DBPObjectWithDescription)prevAttribute, monitor);
                }
                prompt.append(attribute.getName());
                formatter.addColumnTypeIfNeeded(prompt, attribute, monitor);
                prevAttribute = attribute;
            }
        }
        return prevAttribute;
    }

    private boolean isRequiresFullyQualifiedName(@NotNull DBSObject object, @Nullable DBCExecutionContext context) {
        if (context == null || context.getContextDefaults() == null) {
            return false;
        }
        DBSObject parent = object.getParentObject();
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        return parent != null && !parent.equals(contextDefaults.getDefaultCatalog()) && !parent.equals(contextDefaults.getDefaultSchema());
    }

    private MetadataProcessor() {
    }
}

