/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionResponse;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSession;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractAICompletionEngine<SERVICE, REQUEST>
implements DAICompletionEngine<SERVICE> {
    @Override
    @NotNull
    public List<DAICompletionResponse> performQueryCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull DAICompletionMessage message, @NotNull IAIFormatter formatter) throws DBException {
        String result = this.requestCompletion(monitor, context, List.of(message), formatter, false);
        if (result == null) {
            return Collections.emptyList();
        }
        result = result.replaceAll("\n\n", "\n");
        DAICompletionResponse response = this.createCompletionResponse(context, result);
        return Collections.singletonList(response);
    }

    @Override
    @NotNull
    public List<DAICompletionResponse> performSessionCompletion(@NotNull DBRProgressMonitor monitor, @NotNull DAICompletionContext context, @NotNull DAICompletionSession session, @NotNull IAIFormatter formatter, boolean includeAssistantMessages) throws DBException {
        DAICompletionResponse response = new DAICompletionResponse();
        response.setResultCompletion(this.requestCompletion(monitor, context, this.filterMessages(session.getMessages(), includeAssistantMessages), formatter, true));
        return List.of(response);
    }

    @NotNull
    protected List<DAICompletionMessage> filterMessages(List<DAICompletionMessage> messages, boolean includeAssistantMessages) {
        if (includeAssistantMessages) {
            return messages;
        }
        return messages.stream().filter(it -> DAICompletionMessage.Role.USER.equals((Object)it.getRole())).toList();
    }

    @Override
    public abstract Map<String, SERVICE> getServiceMap();

    protected abstract int getMaxTokens();

    @NotNull
    protected String getInstructions(boolean chatCompletion) {
        return "You are SQL assistant. You must produce SQL code for given prompt.\nYou must produce valid SQL statement enclosed with Markdown code block and terminated with semicolon.\nAll comments MUST be placed before query outside markdown code block.\nBe polite.\n";
    }

    @Nullable
    protected abstract String requestCompletion(@NotNull DBRProgressMonitor var1, @NotNull DAICompletionContext var2, @NotNull List<DAICompletionMessage> var3, @NotNull IAIFormatter var4, boolean var5) throws DBException;

    @NotNull
    protected DAICompletionResponse createCompletionResponse(@NotNull DAICompletionContext context, @NotNull String result) {
        DAICompletionResponse response = new DAICompletionResponse();
        response.setResultCompletion(result);
        return response;
    }

    @Nullable
    protected abstract String callCompletion(@NotNull DBRProgressMonitor var1, boolean var2, @NotNull List<DAICompletionMessage> var3, @NotNull SERVICE var4, @NotNull REQUEST var5) throws DBException;

    @NotNull
    protected DBSObjectContainer getScopeObject(@NotNull DAICompletionContext context, @NotNull DBCExecutionContext executionContext) {
        DAICompletionScope scope = context.getScope();
        DBSObjectContainer mainObject = null;
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults != null) {
            switch (scope) {
                case CURRENT_SCHEMA: {
                    if (contextDefaults.getDefaultSchema() != null) {
                        mainObject = contextDefaults.getDefaultSchema();
                        break;
                    }
                    mainObject = contextDefaults.getDefaultCatalog();
                    break;
                }
                case CURRENT_DATABASE: {
                    mainObject = contextDefaults.getDefaultCatalog();
                    break;
                }
            }
        }
        if (mainObject == null) {
            mainObject = (DBSObjectContainer)executionContext.getDataSource();
        }
        return mainObject;
    }

    protected abstract REQUEST createCompletionRequest(boolean var1, @NotNull List<DAICompletionMessage> var2) throws DBCException;

    protected abstract REQUEST createCompletionRequest(boolean var1, @NotNull List<DAICompletionMessage> var2, int var3) throws DBCException;

    protected abstract SERVICE getServiceInstance(@NotNull DBCExecutionContext var1) throws DBException;

    protected abstract AIEngineSettings getSettings();

    @Nullable
    protected String processCompletion(@NotNull List<DAICompletionMessage> messages, @NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer mainObject, @Nullable String completionText, @NotNull IAIFormatter formatter, @NotNull boolean isChatAPI) {
        if (CommonUtils.isEmpty((String)completionText)) {
            return null;
        }
        if (!isChatAPI) {
            completionText = "SELECT " + ((String)completionText).trim() + ";";
        }
        return formatter.postProcessGeneratedQuery(monitor, mainObject, executionContext, (String)completionText).trim();
    }

    @NotNull
    protected static List<DAICompletionMessage> truncateMessages(boolean chatMode, @NotNull List<DAICompletionMessage> messages, int maxTokens) {
        ArrayList<DAICompletionMessage> pending = new ArrayList<DAICompletionMessage>(messages);
        ArrayList<DAICompletionMessage> truncated = new ArrayList<DAICompletionMessage>();
        int remainingTokens = maxTokens - 20;
        if (!pending.isEmpty() && ((DAICompletionMessage)pending.get(0)).getRole() == DAICompletionMessage.Role.SYSTEM) {
            DAICompletionMessage msg = (DAICompletionMessage)pending.remove(0);
            remainingTokens -= AbstractAICompletionEngine.truncateMessage(msg, remainingTokens - 50);
            truncated.add(msg);
        }
        for (DAICompletionMessage message : pending) {
            int messageTokens = message.getContent().length();
            if ((remainingTokens < 0 || messageTokens > remainingTokens) && chatMode) break;
            remainingTokens -= AbstractAICompletionEngine.truncateMessage(message, remainingTokens);
            truncated.add(message);
        }
        return truncated;
    }

    protected static int truncateMessage(DAICompletionMessage message, int remainingTokens) {
        String content = message.getContent();
        int contentTokens = AbstractAICompletionEngine.countContentTokens(content);
        if (contentTokens > remainingTokens) {
            int tokensToRemove = contentTokens - remainingTokens;
            content = AbstractAICompletionEngine.removeContentTokens(content, tokensToRemove);
            message.setContent(content);
            return contentTokens - tokensToRemove;
        }
        return contentTokens;
    }

    protected static String removeContentTokens(String content, int tokensToRemove) {
        int charsToRemove = tokensToRemove * 2;
        if (charsToRemove >= content.length()) {
            return "";
        }
        return content.substring(0, content.length() - charsToRemove) + "..";
    }

    protected static int countContentTokens(String content) {
        return content.length() / 2;
    }
}

