/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.ai.MessageChunk;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AITextUtils {
    private AITextUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String convertToSQL(@NotNull DAICompletionMessage prompt, @NotNull MessageChunk[] response, @Nullable DBPDataSource dataSource) {
        StringBuilder builder = new StringBuilder();
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.includeSourceTextInQuery")) {
            builder.append(SQLUtils.generateCommentLine((DBPDataSource)dataSource, (String)prompt.getContent()));
        }
        MessageChunk[] messageChunkArray = response;
        int n = response.length;
        int n2 = 0;
        while (n2 < n) {
            MessageChunk chunk = messageChunkArray[n2];
            MessageChunk messageChunk = chunk;
            if (messageChunk instanceof MessageChunk.Code) {
                void code;
                MessageChunk.Code cfr_ignored_0 = (MessageChunk.Code)messageChunk;
                MessageChunk.Code cfr_ignored_1 = (MessageChunk.Code)messageChunk;
                builder.append(code.text()).append(System.lineSeparator());
            } else {
                MessageChunk messageChunk2 = chunk;
                if (messageChunk2 instanceof MessageChunk.Text) {
                    void text;
                    MessageChunk.Text cfr_ignored_2 = (MessageChunk.Text)messageChunk2;
                    MessageChunk.Text cfr_ignored_3 = (MessageChunk.Text)messageChunk2;
                    builder.append(SQLUtils.generateCommentLine((DBPDataSource)dataSource, (String)text.text()));
                }
            }
            ++n2;
        }
        return builder.toString().trim();
    }

    @NotNull
    public static MessageChunk[] splitIntoChunks(@NotNull String text) {
        if (text.startsWith("SELECT") && text.endsWith(";")) {
            return new MessageChunk[]{new MessageChunk.Code(text, "sql")};
        }
        ArrayList<Record> chunks = new ArrayList<Record>();
        StringBuilder buffer = new StringBuilder();
        String codeBlockTag = null;
        String[] stringArray = (String[])text.lines().toArray(String[]::new);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("```")) {
                if (!buffer.isEmpty()) {
                    if (codeBlockTag != null) {
                        chunks.add(new MessageChunk.Code(buffer.toString(), codeBlockTag));
                    } else {
                        chunks.add(new MessageChunk.Text(buffer.toString()));
                    }
                    buffer.setLength(0);
                }
                codeBlockTag = codeBlockTag != null ? null : line.substring(3);
            } else {
                if (!buffer.isEmpty()) {
                    buffer.append('\n');
                }
                buffer.append(line);
            }
            ++n2;
        }
        if (!buffer.isEmpty()) {
            if (codeBlockTag != null) {
                chunks.add(new MessageChunk.Code(buffer.toString(), codeBlockTag));
            } else {
                chunks.add(new MessageChunk.Text(buffer.toString()));
            }
        }
        return (MessageChunk[])chunks.toArray(MessageChunk[]::new);
    }
}

