/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AISettingsRegistry {
    private static final Log log = Log.getLog(AISettingsRegistry.class);
    public static final String AI_CONFIGURATION_JSON = "ai-configuration.json";
    private static AISettingsRegistry instance = null;
    private static final Gson gson = new Gson();
    private final Set<Consumer<AISettingsRegistry>> settingsChangedListeners = Collections.synchronizedSet(new HashSet());

    private AISettingsRegistry() {
        WorkspaceConfigEventManager.addConfigChangedListener((String)AI_CONFIGURATION_JSON, o -> {
            this.getSettingsHolder().reset();
            this.raiseChangedEvent(this);
        });
    }

    public static synchronized AISettingsRegistry getInstance() {
        if (instance == null) {
            instance = new AISettingsRegistry();
        }
        return instance;
    }

    public void addChangedListener(Consumer<AISettingsRegistry> listener) {
        this.settingsChangedListeners.add(listener);
    }

    public void removeChangedListener(Consumer<AISettingsRegistry> listener) {
        this.settingsChangedListeners.remove(listener);
    }

    private void raiseChangedEvent(AISettingsRegistry registry) {
        Consumer[] consumerArray = (Consumer[])this.settingsChangedListeners.toArray(Consumer[]::new);
        int n = consumerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Consumer listener = consumerArray[n2];
            listener.accept(registry);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AISettingsHolder getSettingsHolder() {
        SMSession sMSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (sMSession instanceof SMSessionPersistent) {
            void session;
            SMSessionPersistent sMSessionPersistent = (SMSessionPersistent)sMSession;
            SMSessionPersistent cfr_ignored_0 = (SMSessionPersistent)sMSession;
            return AISettingsSessionHolder.getForSession((SMSessionPersistent)session);
        }
        return AISettingsLocalHolder.INSTANCE;
    }

    @NotNull
    public AISettings getSettings() {
        return this.getSettingsHolder().getSettings();
    }

    @NotNull
    private static AISettings loadSettingsFromConfig() {
        AISettings settings;
        try {
            String content = AISettingsRegistry.loadConfig();
            settings = CommonUtils.isEmpty((String)content) ? AISettingsRegistry.prepareDefaultSettings() : (AISettings)gson.fromJson((Reader)new StringReader(content), AISettings.class);
        }
        catch (Exception e) {
            log.error((Object)"Error loading AI settings, falling back to defaults.", (Throwable)e);
            settings = AISettingsRegistry.prepareDefaultSettings();
        }
        if (settings.getActiveEngine() == null) {
            settings.setActiveEngine("openai");
        }
        return settings;
    }

    private static AISettings prepareDefaultSettings() {
        AISettings settings = new AISettings();
        if (DBWorkbench.getPlatform().getPreferenceStore().getString("ai.completion.disabled") != null) {
            settings.setAiDisabled(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.disabled"));
        } else {
            settings.setAiDisabled(false);
        }
        return settings;
    }

    public void saveSettings(AISettings settings) {
        try {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to save AI configuration");
                return;
            }
            String content = gson.toJson((Object)settings, AISettings.class);
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(AI_CONFIGURATION_JSON, content);
            this.getSettingsHolder().setSettings(settings);
        }
        catch (Exception e) {
            log.error((Object)"Error saving AI configuration", (Throwable)e);
        }
        this.raiseChangedEvent(this);
    }

    private static String loadConfig() throws DBException {
        return DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(AI_CONFIGURATION_JSON);
    }

    public static boolean isConfigExists() throws DBException {
        String content = AISettingsRegistry.loadConfig();
        return CommonUtils.isNotEmpty((String)content);
    }

    private static interface AISettingsHolder {
        public AISettings getSettings();

        public void setSettings(AISettings var1);

        public void reset();
    }

    private static class AISettingsLocalHolder
    implements AISettingsHolder {
        public static final AISettingsHolder INSTANCE = new AISettingsLocalHolder();
        private AISettings settings = null;

        private AISettingsLocalHolder() {
        }

        @Override
        public synchronized AISettings getSettings() {
            AISettings settings = this.settings;
            if (settings == null) {
                this.settings = settings = AISettingsRegistry.loadSettingsFromConfig();
            }
            return settings;
        }

        @Override
        public synchronized void setSettings(AISettings mruSettings) {
            this.settings = mruSettings;
        }

        @Override
        public synchronized void reset() {
            this.settings = null;
        }
    }

    private static class AISettingsSessionHolder
    implements AISettingsHolder {
        private static final Map<SMSessionPersistent, AISettingsSessionHolder> holderBySession = Collections.synchronizedMap(new WeakHashMap());
        private final SMSessionPersistent session;
        private AISettings mruSettings = null;

        private AISettingsSessionHolder(SMSessionPersistent session) {
            this.session = session;
        }

        public static AISettingsHolder getForSession(SMSessionPersistent session) {
            return holderBySession.computeIfAbsent(session, s -> new AISettingsSessionHolder((SMSessionPersistent)s));
        }

        public static void resetAll() {
            holderBySession.clear();
        }

        @Override
        public synchronized AISettings getSettings() {
            AISettings mruSettings = this.mruSettings;
            AISettings sharedSettings = (AISettings)this.session.getAttribute(AISettings.class.getName());
            if (mruSettings == null || !mruSettings.equals(sharedSettings)) {
                mruSettings = AISettingsRegistry.loadSettingsFromConfig();
                this.setSettings(mruSettings);
            }
            return mruSettings;
        }

        @Override
        public synchronized void setSettings(AISettings mruSettings) {
            this.mruSettings = mruSettings;
            this.session.setAttribute(AISettings.class.getName(), (Object)mruSettings);
        }

        @Override
        public synchronized void reset() {
            AISettingsSessionHolder.resetAll();
        }
    }
}

