/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AISettings {
    private static final Log log = Log.getLog(AISettings.class);
    private boolean aiDisabled;
    private String activeEngine;
    private final Map<String, AIEngineSettings> engineConfigurations = new LinkedHashMap<String, AIEngineSettings>();

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    @Property
    public String getActiveEngine() {
        return this.activeEngine;
    }

    public void setActiveEngine(String activeEngine) {
        this.activeEngine = activeEngine;
    }

    @NotNull
    public Map<String, AIEngineSettings> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    @NotNull
    public AIEngineSettings getEngineConfiguration(String engine) {
        AIEngineSettings settings = this.engineConfigurations.get(engine);
        if (settings == null) {
            settings = new AIEngineSettings();
            settings.setEngineEnabled(!this.aiDisabled);
            this.engineConfigurations.put(engine, settings);
        }
        this.tryMigrateFromPrefStore(engine, settings);
        return settings;
    }

    private void tryMigrateFromPrefStore(String engine, AIEngineSettings settings) {
        if ("openai".equals(engine) && settings.getProperties().get("gpt.model") == null) {
            DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String model = preferenceStore.getString("gpt.model");
            if (model != null) {
                settings.getProperties().put("gpt.model", model);
            }
            Double temperature = preferenceStore.getDouble("gpt.model.temperature");
            settings.getProperties().put("gpt.model.temperature", temperature);
            Boolean logQuery = preferenceStore.getBoolean("gpt.log.query");
            settings.getProperties().put("gpt.log.query", logQuery);
        }
    }
}

