/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CouchbaseDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(CouchbaseDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.couchbase";
    private final CouchbaseDataSource dataSource;
    private Version serverVersion;

    public CouchbaseDataSourceInfo(CouchbaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDatabaseProductName() {
        JsonObject rawInfo = ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getClusterInfo().raw();
        JsonArray nodes = rawInfo.getArray("nodes");
        if (nodes != null && !nodes.isEmpty()) {
            return "Couchbase " + nodes.getObject(0).getString("version");
        }
        return "Couchbase";
    }

    public String getDatabaseProductVersion() {
        return this.getDatabaseVersion().toString();
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Couchbase driver bundle 'org.jkiss.bundle.couchbase' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        if (this.serverVersion == null) {
            ClusterInfo clusterInfo = ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getClusterInfo();
            com.couchbase.client.java.util.features.Version minVersion = clusterInfo.getMinVersion();
            this.serverVersion = new Version(minVersion.major(), minVersion.minor(), minVersion.patch());
        }
        return this.serverVersion;
    }

    public String getDriverName() {
        return ((CouchbaseExecutionContext)this.dataSource.getDefaultContext()).getEnvironment().packageNameAndVersion();
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return null;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return true;
    }

    public boolean isDynamicMetadata() {
        return true;
    }
}

