/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model;

import com.dbeaver.db.mssql.model.SQLServerJobSchedule;
import com.dbeaver.db.mssql.model.SQLServerJobStep;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class SQLServerJob
implements SQLServerObject,
DBPUniqueObject,
DBPRefreshableObject,
DBPStatefulObject {
    private final SQLServerDataSource dataSource;
    private final String id;
    private final String name;
    private final String description;
    private final String owner;
    private final String category;
    private final int startStepId;
    private final boolean enabled;
    private final StepCache stepCache = new StepCache();
    private final ScheduleCache scheduleCache = new ScheduleCache();

    public SQLServerJob(@NotNull SQLServerDataSource dataSource, @NotNull ResultSet dbResult) {
        this.dataSource = dataSource;
        this.id = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"job_id");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner");
        this.category = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"category_name");
        this.startStepId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"start_step_id");
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"enabled");
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getUniqueName() {
        return this.id;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=4, specific=true)
    @NotNull
    public String getCategory() {
        return this.category;
    }

    @Property(viewable=true, order=5, specific=true)
    @Nullable
    public SQLServerJobStep getStartStep(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getStep(monitor, this.startStepId);
    }

    @Property(viewable=true, order=6)
    public boolean isEnabled() {
        return this.enabled;
    }

    @Association
    @NotNull
    public List<SQLServerJobStep> getSteps(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.stepCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public SQLServerJobStep getStep(@NotNull DBRProgressMonitor monitor, int id) throws DBException {
        for (SQLServerJobStep step : this.stepCache.getAllObjects(monitor, (DBSObject)this)) {
            if (step.getPosition() != id) continue;
            return step;
        }
        return null;
    }

    @Association
    @NotNull
    public List<SQLServerJobSchedule> getSchedules(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.scheduleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public long getObjectId() {
        return this.id.hashCode();
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @Nullable
    public SQLServerDatabase getDatabase() {
        return null;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.stepCache.clearCache();
        this.scheduleCache.clearCache();
        return this;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.enabled ? DBSObjectState.ACTIVE : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
        this.stepCache.clearCache();
    }

    private static class ScheduleCache
    extends JDBCObjectCache<SQLServerJob, SQLServerJobSchedule> {
        private ScheduleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerJob job) throws SQLException {
            JDBCPreparedStatement stmt = session.prepareStatement("SELECT\n  js.job_id, s.*,\n  msdb.dbo.agent_datetime(active_start_date, active_start_time) as active_start,\n  msdb.dbo.agent_datetime(active_end_date, active_end_time) as active_end\nFROM msdb.dbo.sysjobschedules js\nJOIN msdb.dbo.sysschedules s ON js.schedule_id = s.schedule_id\nWHERE job_id = ?");
            stmt.setString(1, job.id);
            return stmt;
        }

        @Nullable
        protected SQLServerJobSchedule fetchObject(@NotNull JDBCSession session, @NotNull SQLServerJob job, @NotNull JDBCResultSet resultSet) {
            return new SQLServerJobSchedule(job, (ResultSet)resultSet);
        }
    }

    private static class StepCache
    extends JDBCObjectCache<SQLServerJob, SQLServerJobStep> {
        private StepCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerJob job) throws SQLException {
            JDBCPreparedStatement stmt = session.prepareStatement("SELECT * FROM msdb.dbo.sysjobsteps\nWHERE job_id = ?");
            stmt.setString(1, job.id);
            return stmt;
        }

        @Nullable
        protected SQLServerJobStep fetchObject(@NotNull JDBCSession session, @NotNull SQLServerJob job, @NotNull JDBCResultSet resultSet) {
            return new SQLServerJobStep(job, (ResultSet)resultSet);
        }
    }
}

