/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.oauth;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class OAuthResponseHandler {
    private static final Pattern codeExtractor = Pattern.compile("[?&]code=([^&]+).*$");
    private static final Pattern errorExtractor = Pattern.compile("[?&]error=(([^&]+).*$)");
    private static HttpServer httpServer;
    private static final String CALLBACK_ENDPOINT = "/Callback";
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private int port;

    public void initServer() throws SQLException {
        this.port = this.findOpenPort(IntStream.range(55555, 55559).toArray());
        try {
            httpServer = HttpServer.create(new InetSocketAddress(this.port), 1);
        }
        catch (IOException iOException) {
            throw new SQLException("Can't create callback server");
        }
        httpServer.setExecutor(new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
        httpServer.start();
    }

    public Future<String> requestCode() {
        return this.executor.submit(() -> {
            AtomicReference result = new AtomicReference();
            AtomicBoolean hasErrors = new AtomicBoolean(false);
            httpServer.createContext(CALLBACK_ENDPOINT, exchange -> {
                String answer;
                String query = exchange.getRequestURI().getQuery();
                Matcher codeMatcher = codeExtractor.matcher(query);
                if (codeMatcher.find()) {
                    String code = codeMatcher.group(1);
                    result.set(code);
                    answer = "Auth has been completed";
                } else {
                    hasErrors.set(true);
                    Matcher errorMatcher = errorExtractor.matcher(query);
                    if (errorMatcher.find()) {
                        result.set(errorMatcher.group(1));
                    }
                    answer = "Errors encountered during authorization";
                }
                exchange.sendResponseHeaders(200, answer.getBytes().length);
                exchange.getResponseBody().write(answer.getBytes());
                exchange.close();
            });
            while (result.get() == null) {
                Thread.onSpinWait();
            }
            httpServer.removeContext(CALLBACK_ENDPOINT);
            if (hasErrors.get()) {
                throw new SQLException("Error receiving code " + (String)result.get());
            }
            return (String)result.get();
        });
    }

    public void addStabContext() {
        httpServer.createContext(CALLBACK_ENDPOINT, exchange -> {
            exchange.sendResponseHeaders(200, 0L);
            httpServer.removeContext(CALLBACK_ENDPOINT);
            exchange.close();
        });
    }

    public void closeHttpServer() {
        if (httpServer != null) {
            httpServer.stop(0);
        }
    }

    public int getPort() {
        return this.port;
    }

    private int findOpenPort(int[] ports) {
        int[] nArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            try {
                ServerSocket socket = new ServerSocket(port);
                socket.close();
                return port;
            }
            catch (IOException iOException) {
                ++n2;
            }
        }
        return -1;
    }
}

