/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.oauth;

import com.dbeaver.jdbc.salesforce.oauth.IdentityResponseDTO;
import com.dbeaver.jdbc.salesforce.oauth.OAuthRequestURLBuilder;
import com.dbeaver.jdbc.salesforce.oauth.OAuthResponseDTO;
import com.dbeaver.jdbc.salesforce.oauth.OAuthResponseHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Desktop;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class OAuthHandler {
    protected static final Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();

    private OAuthHandler() {
    }

    public static void authorize(String hostname, Properties properties) throws SQLException {
        String clientID = properties.getProperty("client_id");
        if (CommonUtils.isEmpty((String)clientID)) {
            throw new SQLException("Client ID for the SSO authorization is missing");
        }
        String secretId = properties.getProperty("client_secret");
        OAuthRequestURLBuilder builder = new OAuthRequestURLBuilder();
        builder.clientID(clientID).hostname(hostname);
        int timeout = OAuthHandler.getTimeout(properties);
        OAuthResponseHandler handler = new OAuthResponseHandler();
        try {
            OAuthHandler.authorizeUsingResponseCode(hostname, clientID, secretId, builder, properties, timeout);
        }
        finally {
            handler.closeHttpServer();
        }
    }

    private static void startSSO(OAuthRequestURLBuilder builder, OAuthResponseHandler handler) throws SQLException {
        block5: {
            try {
                handler.initServer();
                builder.redirectURI(String.format("http://localhost:%s/Callback\n", handler.getPort()));
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(URI.create(builder.build()));
                        break block5;
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                throw new SQLException("Desktop BROWSER interface is not supported");
            }
            catch (Throwable e) {
                throw new SQLException("Error acquiring auth code", e);
            }
        }
    }

    private static void authorizeUsingResponseCode(String hostname, String clientID, String secretId, OAuthRequestURLBuilder builder, Properties properties, int timeout) throws SQLException {
        block12: {
            OAuthResponseHandler handler = new OAuthResponseHandler();
            try {
                String code;
                String verifier = OAuthHandler.generateCodeChallengeAndVerifier(builder);
                OAuthHandler.startSSO(builder, handler);
                try {
                    code = handler.requestCode().get(timeout, TimeUnit.SECONDS);
                }
                catch (Throwable e) {
                    throw new SQLException("Error while reading response code value", e);
                }
                HttpRequest.Builder postBuilder = HttpRequest.newBuilder().uri(URI.create(String.format("https://%s/services/oauth2/token", hostname)));
                postBuilder.header("Content-type", "application/x-www-form-urlencoded");
                postBuilder.POST(HttpRequest.BodyPublishers.ofString(OAuthHandler.createTokenRequestParameters(code, secretId, clientID, verifier, handler.getPort())));
                postBuilder.timeout(Duration.ofSeconds(timeout));
                HttpRequest postRequest = postBuilder.build();
                try {
                    handler.addStabContext();
                    HttpClient client = HttpClient.newBuilder().cookieHandler(new CookieManager()).version(HttpClient.Version.HTTP_2).build();
                    HttpResponse<String> response = client.send(postRequest, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() != 200) {
                        throw new SQLException("Error getting token info " + response.body());
                    }
                    response.body();
                    OAuthResponseDTO oAuthResponse = (OAuthResponseDTO)gson.fromJson(response.body(), OAuthResponseDTO.class);
                    if (oAuthResponse.access_token() != null) {
                        String token = oAuthResponse.access_token();
                        properties.put("auth-token", token);
                        if (oAuthResponse.id() != null) {
                            String id = oAuthResponse.id();
                            HttpResponse<String> serviceRequest = OAuthHandler.sendServiceRequest(id, client, token, timeout);
                            if (serviceRequest.statusCode() != 200) {
                                throw new SQLException("Error getting service info " + response.statusCode());
                            }
                            String serviceResponse = serviceRequest.body();
                            IdentityResponseDTO identityResponseDTO = (IdentityResponseDTO)gson.fromJson(serviceResponse, IdentityResponseDTO.class);
                            if (identityResponseDTO.urls().partner() != null) {
                                properties.setProperty("service_endpoint", identityResponseDTO.urls().partner().replace("{version}", "58.0"));
                            }
                        }
                        break block12;
                    }
                    throw new SQLException("Error extracting token");
                }
                catch (Throwable e) {
                    throw new SQLException("Error getting token info", e);
                }
            }
            finally {
                handler.closeHttpServer();
            }
        }
    }

    private static HttpResponse<String> sendServiceRequest(String id, HttpClient client, String token, int timeout) throws IOException, InterruptedException {
        HttpRequest idRequest = HttpRequest.newBuilder().uri(URI.create(id)).setHeader("Authorization", "Bearer " + token).GET().timeout(Duration.ofSeconds(timeout)).build();
        return client.send(idRequest, HttpResponse.BodyHandlers.ofString());
    }

    @NotNull
    private static String generateCodeChallengeAndVerifier(OAuthRequestURLBuilder builder) throws SQLException {
        String codeVerifier = OAuthHandler.generateVerifier();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] shaEncode = digest.digest(codeVerifier.getBytes());
            String s = Base64.getUrlEncoder().withoutPadding().encodeToString(shaEncode);
            builder.codeChallenge(s);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLException("Missing SHA-256 algorithm");
        }
        return codeVerifier;
    }

    private static int getTimeout(Properties properties) {
        String timeoutProperty = properties.getProperty("sso.timeout");
        int timeout = timeoutProperty != null ? Integer.parseInt(timeoutProperty) : 120;
        return timeout;
    }

    private static String generateVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] secureValue = new byte[128];
        secureRandom.nextBytes(secureValue);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(secureValue);
    }

    private static String createTokenRequestParameters(String code, String clientSecret, String clientID, String verifier, int port) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "authorization_code");
        parameters.put("code", code);
        parameters.put("client_id", clientID);
        if (clientSecret != null && !clientSecret.isEmpty()) {
            parameters.put("client_secret", clientSecret);
        }
        parameters.put("code_verifier", verifier);
        parameters.put("redirect_uri", URLEncoder.encode(String.format("http://localhost:%s/Callback\n", port), StandardCharsets.UTF_8));
        return parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }
}

