/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.dashboard.registry;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.dashboard.DBDashboardContext;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.DBDashboardProvider;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistryListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DashboardRegistry {
    private static final Log log = Log.getLog(DashboardRegistry.class);
    public static final String CONFIG_FILE_NAME = "dashboards.xml";
    private static DashboardRegistry instance = null;
    private final Object syncRoot = new Object();
    private final List<DashboardRegistryListener> listeners = new ArrayList<DashboardRegistryListener>();
    private final Map<String, DashboardProviderDescriptor> dashboardProviders = new LinkedHashMap<String, DashboardProviderDescriptor>();
    private final Map<String, DashboardItemConfiguration> dashboardItems = new LinkedHashMap<String, DashboardItemConfiguration>();

    public static synchronized DashboardRegistry getInstance() {
        if (instance == null) {
            instance = new DashboardRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DashboardRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dashboard");
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("provider".equals(ext.getName())) {
                DashboardProviderDescriptor provider = new DashboardProviderDescriptor(ext);
                this.dashboardProviders.put(provider.getId(), provider);
            }
            ++n2;
        }
        new DBDashboardContext();
        for (DashboardProviderDescriptor dp : this.dashboardProviders.values()) {
            for (DashboardItemConfiguration dashboard : dp.getInstance().loadStaticDashboards(dp)) {
                this.dashboardItems.put(dashboard.getId(), dashboard);
            }
        }
        this.loadConfigFromFile();
        WorkspaceConfigEventManager.addConfigChangedListener((String)CONFIG_FILE_NAME, o -> this.loadConfigFromFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFromFile() {
        try {
            String configContent = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(CONFIG_FILE_NAME);
            if (CommonUtils.isEmpty((String)configContent) && !DBWorkbench.isDistributed() && CommonUtils.isEmpty((String)(configContent = DBWorkbench.getPlatform().getPluginConfigurationController("org.jkiss.dbeaver.model.dashboard").loadConfigurationFile(CONFIG_FILE_NAME)))) {
                configContent = DBWorkbench.getPlatform().getPluginConfigurationController("org.jkiss.dbeaver.ui.dashboard").loadConfigurationFile(CONFIG_FILE_NAME);
            }
            Object object = this.syncRoot;
            synchronized (object) {
                this.dashboardItems.values().removeIf(DashboardItemConfiguration::isCustom);
                if (CommonUtils.isNotEmpty((String)configContent)) {
                    Document dbDocument = XMLUtils.parseDocument((Reader)new StringReader(configContent));
                    for (Element dbElement : XMLUtils.getChildElementList((Element)dbDocument.getDocumentElement(), (String)"dashboard")) {
                        DashboardItemConfiguration dashboard = new DashboardItemConfiguration(this, dbElement);
                        this.dashboardItems.put(dashboard.getId(), dashboard);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading dashboard configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfigFile() {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            log.warn((Object)"The user has no permission to save dashboards configuration");
            return;
        }
        try {
            StringWriter out = new StringWriter();
            XMLBuilder xml = new XMLBuilder((Writer)out, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            Throwable throwable = null;
            Object var4_6 = null;
            try (XMLBuilder.Element e = xml.startElement("dashboards");){
                Object object = this.syncRoot;
                synchronized (object) {
                    for (DashboardItemConfiguration dashboard : this.dashboardItems.values()) {
                        if (!dashboard.isCustom()) continue;
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (XMLBuilder.Element e1 = xml.startElement("dashboard");){
                            dashboard.serialize(xml);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            xml.flush();
            out.flush();
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(CONFIG_FILE_NAME, out.getBuffer().toString());
        }
        catch (Exception e) {
            log.error((Object)"Error saving dashboard configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DashboardItemConfiguration> getAllDashboards() {
        Object object = this.syncRoot;
        synchronized (object) {
            return new ArrayList<DashboardItemConfiguration>(this.dashboardItems.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardItemConfiguration findDashboardItem(@NotNull DBRProgressMonitor monitor, @NotNull DBDashboardContext context, @NotNull String id) throws DBException {
        int divPos = id.indexOf(58);
        String providerId = "database";
        if (divPos != -1) {
            providerId = id.substring(0, divPos);
            id = id.substring(divPos + 1);
        }
        divPos = id.lastIndexOf(47);
        String path = null;
        if (divPos != -1) {
            path = id.substring(0, divPos);
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            id = id.substring(divPos + 1);
        }
        if (!CommonUtils.isEmpty(path)) {
            DashboardProviderDescriptor provider = this.getDashboardProvider(providerId);
            if (provider == null) {
                log.debug((Object)("Dashboard provider '" + providerId + "' not found"));
                return null;
            }
            DBDashboardFolder curFolder = null;
            String[] stringArray = path.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pathItem = stringArray[n2];
                if ((curFolder = curFolder == null ? this.findFolder(provider.getInstance().loadRootFolders(monitor, provider, context), pathItem) : this.findFolder(curFolder.loadSubFolders(monitor, context), pathItem)) == null) break;
                ++n2;
            }
            if (curFolder == null) {
                log.debug((Object)("Dashboard polder path '" + path + "' cannot be resolved"));
                return null;
            }
            for (DashboardItemConfiguration dashboard : curFolder.loadDashboards(monitor, context)) {
                if (!dashboard.getId().equals(id)) continue;
                return dashboard;
            }
            log.debug((Object)("Dashboard '" + id + "' not found in path '" + path + "'"));
            return null;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            return this.dashboardItems.get(id);
        }
    }

    private DBDashboardFolder findFolder(List<DBDashboardFolder> folders, String id) {
        for (DBDashboardFolder folder : folders) {
            if (!folder.getId().equals(id)) continue;
            return folder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashboardItemConfiguration getDashboardItem(String id) {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.dashboardItems.get(id);
        }
    }

    public List<DashboardProviderDescriptor> getDashboardProviders() {
        return new ArrayList<DashboardProviderDescriptor>(this.dashboardProviders.values());
    }

    public List<DashboardProviderDescriptor> getDashboardProviders(DBPDataSourceContainer dataSource) {
        if (dataSource != null) {
            return this.dashboardProviders.values().stream().filter(dp -> dp.appliesTo((DBPObject)dataSource)).sorted(Comparator.comparing(DashboardProviderDescriptor::getName)).toList();
        }
        return this.dashboardProviders.values().stream().filter(DashboardProviderDescriptor::isEnabled).filter(d -> !d.isDatabaseRequired()).sorted(Comparator.comparing(DashboardProviderDescriptor::getName)).toList();
    }

    public DashboardProviderDescriptor getDashboardProvider(String id) {
        return this.dashboardProviders.get(id);
    }

    public DBDashboardProvider getDashboardProviderInstance(String id) {
        DashboardProviderDescriptor dpd = this.dashboardProviders.get(id);
        if (dpd != null) {
            return dpd.getInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public List<DashboardItemConfiguration> getDashboardItems(@Nullable DashboardProviderDescriptor provider, @Nullable DBPNamedObject source, boolean defaultOnly) {
        DBPNamedObject dBPNamedObject = source;
        if (dBPNamedObject instanceof DBPDataSourceContainer) {
            void dsc;
            DBPDataSourceContainer dBPDataSourceContainer = (DBPDataSourceContainer)dBPNamedObject;
            DBPDataSourceContainer cfr_ignored_0 = (DBPDataSourceContainer)dBPNamedObject;
            source = dsc.getDriver();
        }
        String providerId = null;
        String driverId = null;
        String driverClass = null;
        DBPNamedObject dBPNamedObject2 = source;
        if (dBPNamedObject2 instanceof DBPDataSourceProviderDescriptor) {
            void dspd;
            DBPDataSourceProviderDescriptor dBPDataSourceProviderDescriptor = (DBPDataSourceProviderDescriptor)dBPNamedObject2;
            DBPDataSourceProviderDescriptor cfr_ignored_1 = (DBPDataSourceProviderDescriptor)dBPNamedObject2;
            providerId = dspd.getId();
        } else {
            DBPNamedObject dBPNamedObject3 = source;
            if (dBPNamedObject3 instanceof DBPDriver) {
                void driver;
                DBPDriver dBPDriver = (DBPDriver)dBPNamedObject3;
                DBPDriver cfr_ignored_2 = (DBPDriver)dBPNamedObject3;
                providerId = driver.getProviderId();
                driverId = driver.getId();
                driverClass = driver.getDriverClassName();
            }
        }
        ArrayList<DashboardItemConfiguration> result = new ArrayList<DashboardItemConfiguration>();
        Object object = this.syncRoot;
        synchronized (object) {
            for (DashboardItemConfiguration dd : this.dashboardItems.values()) {
                if (provider != null && provider != dd.getDashboardProvider() || providerId != null && !dd.matches(providerId, driverId, driverClass) || defaultOnly && !dd.isShowByDefault()) continue;
                result.add(dd);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDashboardItem(DashboardItemConfiguration itemConfiguration) throws IllegalArgumentException {
        Object object = this.syncRoot;
        synchronized (object) {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                throw new IllegalArgumentException("The user has no permission to create dashboard configuration");
            }
            if (this.dashboardItems.containsKey(itemConfiguration.getId())) {
                throw new IllegalArgumentException("Dashboard " + itemConfiguration.getId() + "' already exists");
            }
            if (!itemConfiguration.isCustom()) {
                throw new IllegalArgumentException("Only custom dashboards can be added");
            }
            this.dashboardItems.put(itemConfiguration.getId(), itemConfiguration);
            this.saveConfigFile();
        }
        for (DashboardRegistryListener listener : this.listeners) {
            listener.handleItemCreate(itemConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDashboardItem(DashboardItemConfiguration dashboard) throws IllegalArgumentException {
        Object object = this.syncRoot;
        synchronized (object) {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                throw new IllegalArgumentException("The user has no permission to remove dashboard configuration");
            }
            if (!this.dashboardItems.containsKey(dashboard.getId())) {
                throw new IllegalArgumentException("Dashboard " + dashboard.getId() + "' doesn't exist");
            }
            if (!dashboard.isCustom()) {
                throw new IllegalArgumentException("Only custom dashboards can be removed");
            }
            this.dashboardItems.remove(dashboard.getId());
            this.saveConfigFile();
        }
        for (DashboardRegistryListener listener : this.listeners) {
            listener.handleItemDelete(dashboard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBPNamedObject> getAllSupportedSources(@NotNull DashboardProviderDescriptor dpd) {
        LinkedHashSet<DBPNamedObject> result = new LinkedHashSet<DBPNamedObject>();
        Object object = this.syncRoot;
        synchronized (object) {
            for (DashboardItemConfiguration dd : this.dashboardItems.values()) {
                if (dd.getDashboardProvider() != dpd) continue;
                result.addAll(dd.getSupportedSources());
            }
        }
        ArrayList<DBPNamedObject> sortedDrivers = new ArrayList<DBPNamedObject>(result);
        sortedDrivers.sort(Comparator.comparing(DBPNamedObject::getName));
        return sortedDrivers;
    }

    public void saveSettings() {
        this.saveConfigFile();
    }

    public synchronized void addListener(@NotNull DashboardRegistryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(@NotNull DashboardRegistryListener listener) {
        this.listeners.remove(listener);
    }
}

