/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.Immutable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@Immutable
final class ScramSHA256 {
    private ScramSHA256() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static byte[] scramSHA256(byte[] salt, byte[] passwd, byte[] clientNonce, byte[] serverNonce) {
        return ScramSHA256._scramSHA256WithServerProof(salt, passwd, clientNonce, serverNonce, false, 0)[0];
    }

    static byte[][] scramPBKDF2SHA256(byte[] salt, byte[] passwd, byte[] clientNonce, byte[] serverNonce, int iterations) {
        return ScramSHA256._scramSHA256WithServerProof(salt, passwd, clientNonce, serverNonce, true, iterations);
    }

    private static byte[][] _scramSHA256WithServerProof(byte[] salt, byte[] passwd, byte[] clientNonce, byte[] serverNonce, boolean usePBKDF2, int pbkdf2Iterations) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"SHA-256 not implemented");
        }
        int saltLen = salt.length;
        int clientNonceLen = clientNonce.length;
        int serverNonceLen = serverNonce.length;
        byte[] salted_pass = usePBKDF2 ? ScramSHA256._pbkdf2WithHmacSHA256(salt, passwd, pbkdf2Iterations, 256) : ScramSHA256._hmac(salt, passwd, digest);
        byte[] server_verifier = ScramSHA256._hmac(salt, salted_pass, digest);
        byte[] client_key = digest.digest(salted_pass);
        byte[] client_verifier = digest.digest(client_key);
        byte[] content = new byte[saltLen + clientNonceLen + serverNonceLen];
        System.arraycopy(salt, 0, content, 0, saltLen);
        System.arraycopy(serverNonce, 0, content, saltLen, serverNonceLen);
        System.arraycopy(clientNonce, 0, content, saltLen + serverNonceLen, clientNonceLen);
        byte[] sharedKey = ScramSHA256._hmac(content, client_verifier, digest);
        byte[] clientProof = new byte[sharedKey.length];
        for (int i = sharedKey.length - 1; i >= 0; --i) {
            clientProof[i] = (byte)(sharedKey[i] ^ client_key[i]);
        }
        byte[] content2 = new byte[clientNonceLen + saltLen + serverNonceLen];
        System.arraycopy(clientNonce, 0, content2, 0, clientNonceLen);
        System.arraycopy(salt, 0, content2, clientNonceLen, saltLen);
        System.arraycopy(serverNonce, 0, content2, saltLen + clientNonceLen, serverNonceLen);
        byte[] serverProof = ScramSHA256._hmac(content2, server_verifier, digest);
        byte[][] retVal = new byte[][]{clientProof, serverProof};
        return retVal;
    }

    private static byte[] _hmac(byte[] data, byte[] key, MessageDigest digest) {
        int i;
        if (key.length > 64) {
            digest.update(key);
            key = digest.digest();
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ key[i]);
            int n2 = i;
            opad[n2] = (byte)(opad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(ipad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        data = digest.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(opad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return digest.digest(content);
    }

    private static byte[] _pbkdf2WithHmacSHA256(byte[] salt, byte[] passwd, int iterations, int keyLength) {
        try {
            PBEKeySpec spec = new PBEKeySpec(new String(passwd, StandardCharsets.UTF_8).toCharArray(), salt, iterations, keyLength);
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            return f.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            return null;
        }
    }
}

