/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.ui;

import com.dbeaver.db.databricks.model.auth.DatabricksPersonalAccessTokenAuthModel;
import com.dbeaver.db.databricks.ui.DatabricksUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DatabricksPersonalAccessTokenAuthConfigurator
implements IObjectPropertyConfigurator<DatabricksPersonalAccessTokenAuthModel, DBPDataSourceContainer> {
    private Text httpPathText;
    private Text pwdText;

    public void createControl(@NotNull Composite authPanel, @NotNull DatabricksPersonalAccessTokenAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.httpPathText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_http_path, (String)"", (int)0x400800);
        this.httpPathText.setMessage(DatabricksUIMessages.auth_configurator_http_path_message);
        this.httpPathText.setToolTipText(DatabricksUIMessages.auth_configurator_http_path_tip);
        this.pwdText = UIUtils.createLabelText((Composite)authPanel, (String)DatabricksUIMessages.auth_configurator_pwd, (String)"", (int)0x400800);
        this.pwdText.setMessage(DatabricksUIMessages.auth_configurator_pwd_message);
        this.pwdText.setToolTipText(DatabricksUIMessages.auth_configurator_pwd_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            this.httpPathText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("httpPath")));
        }
        if (this.pwdText != null && !this.pwdText.isDisposed()) {
            this.pwdText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("PWD")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.httpPathText != null && !this.httpPathText.isDisposed()) {
            connectionInfo.setAuthProperty("httpPath", this.httpPathText.getText().trim());
        }
        if (this.pwdText != null && !this.pwdText.isDisposed()) {
            connectionInfo.setAuthProperty("PWD", this.pwdText.getText().trim());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.httpPathText.getText().isEmpty() && !this.pwdText.getText().isEmpty();
    }
}

