/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ComProtocol {
    public static final ComProtocol INSTANCE = new ComProtocol();

    private ComProtocol() {
    }

    public List<Integer> getOpcodes(int version) throws SQLException {
        ArrayList<Integer> opcodes = new ArrayList<Integer>();
        String state = this.getOpcodeString(version);
        StringTokenizer st = new StringTokenizer(state, ",");
        while (st.hasMoreTokens()) {
            String next = st.nextToken().trim();
            if (next.startsWith("@")) {
                String depend = next.substring(1);
                opcodes.addAll(this.getDependancyOpcodes(Integer.parseInt(depend)));
                continue;
            }
            opcodes.add(new Integer(next));
        }
        return opcodes;
    }

    private List<Integer> getDependancyOpcodes(int dependancy) throws SQLException {
        String next;
        ArrayList<Integer> list = new ArrayList<Integer>();
        String state = this.getOpcodeString(dependancy);
        StringTokenizer st = new StringTokenizer(state, ",");
        while (st.hasMoreTokens() && !(next = st.nextToken().trim()).startsWith("@")) {
            list.add(new Integer(next));
        }
        return list;
    }

    private String getOpcodeString(int version) throws SQLException {
        switch (version) {
            case 2: {
                return "2,3,6,9,8,1000";
            }
            case 3: {
                return "2,-1,3,6,9,8,1000";
            }
        }
        throw new SQLException("Unsupported Protocol '" + version + "'");
    }
}

