/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.cli;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.netezza.ui.Main;
import org.netezza.ui.cli.Command;
import org.netezza.util.NzSecurityLevel;

public class TestConnectionCommand
extends Command {
    String host;
    String port;
    String database;
    String user;
    String password;
    String securityLevel;
    String caCertFile;
    String schema;
    String loginModule;
    String krbSSODelegation;
    String applicationName;
    String clientUser;
    String clientHostName;
    final byte OPTION_HOST = 1;
    final byte OPTION_PORT = (byte)2;
    final byte OPTION_DATABASE = (byte)3;
    final byte OPTION_USER = (byte)4;
    final byte OPTION_PASSWORD = (byte)5;
    final byte OPTION_SECURITY_LEVEL = (byte)6;
    final byte OPTION_CA_CERT_FILE = (byte)7;
    final byte OPTION_SCHEMA = (byte)8;
    final byte OPTION_LOGIN_MODULE = (byte)9;
    final byte OPTION_KRB_SSO_DELEGATION = (byte)10;
    final byte OPTION_APPLICATION_NAME = (byte)11;
    final byte OPTION_CLIENT_USER = (byte)12;
    final byte OPTION_CLIENT_HOST_NAME = (byte)13;
    private static final byte Total_OPTIONS = 12;
    byte option = (byte)-1;

    public TestConnectionCommand() {
        super("Test Connection");
    }

    @Override
    public void start() {
        int length = this.numberOfParameters();
        for (int i = 0; i < length; ++i) {
            String option = this.getOption(i);
            if (option.startsWith("-")) {
                this.checkForError();
                if (option.equals("--host") || option.equals("-h")) {
                    this.option = 1;
                    continue;
                }
                if (option.equals("--port") || option.equals("-p")) {
                    this.option = (byte)2;
                    continue;
                }
                if (option.equals("--database") || option.equals("-db")) {
                    this.option = (byte)3;
                    continue;
                }
                if (option.equals("--user") || option.equals("-u")) {
                    this.option = (byte)4;
                    continue;
                }
                if (option.equals("--password") || option.equals("-pw")) {
                    this.option = (byte)5;
                    continue;
                }
                if (option.equals("--securitylevel") || option.equals("-s")) {
                    this.option = (byte)6;
                    continue;
                }
                if (option.equals("--cacertfile") || option.equals("-f")) {
                    this.option = (byte)7;
                    continue;
                }
                if (option.equals("--schema") || option.equals("-S")) {
                    this.option = (byte)8;
                    continue;
                }
                if (option.equals("--loginModule") || option.equals("-lm")) {
                    this.option = (byte)9;
                    continue;
                }
                if (option.equals("--krbSSODelegation") || option.equals("-kssodel")) {
                    this.option = (byte)10;
                    continue;
                }
                if (option.equals("--applicationName") || option.equals("-appName")) {
                    this.option = (byte)11;
                    continue;
                }
                if (option.equals("--clientUser") || option.equals("-cliUsr")) {
                    this.option = (byte)12;
                    continue;
                }
                if (option.equals("--clientHostName") || option.equals("-cliHost")) {
                    this.option = (byte)13;
                    continue;
                }
                if (option.equals("--help")) {
                    this.help();
                    Main.exit();
                    continue;
                }
                this.printError("Invalid option '" + option + "'.");
                Main.exit();
                continue;
            }
            switch (this.option) {
                case 1: {
                    this.host = option;
                    break;
                }
                case 2: {
                    this.port = option;
                    break;
                }
                case 3: {
                    this.database = option;
                    break;
                }
                case 4: {
                    this.user = option;
                    break;
                }
                case 5: {
                    this.password = option;
                    break;
                }
                case 6: {
                    this.securityLevel = option;
                    break;
                }
                case 7: {
                    this.caCertFile = option;
                    break;
                }
                case 8: {
                    this.schema = option;
                    break;
                }
                case 9: {
                    this.loginModule = option;
                    break;
                }
                case 10: {
                    this.krbSSODelegation = option;
                    break;
                }
                case 11: {
                    this.applicationName = option;
                    break;
                }
                case 12: {
                    this.clientUser = option;
                    break;
                }
                case 13: {
                    this.clientHostName = option;
                    break;
                }
                default: {
                    this.printError("Invalid option");
                    Main.exit();
                }
            }
            this.option = (byte)-1;
        }
        this.checkForError();
        this.host = this.host == null || this.host.trim().length() == 0 ? this.getValue("Host(localhost)").trim() : this.host;
        String string = this.host = this.host.length() == 0 ? "localhost" : this.host;
        while (this.port == null) {
            this.port = this.port == null || this.port.trim().length() == 0 ? this.getValue("Port(5480)").trim() : this.port;
            this.port = this.port.length() == 0 ? "5480" : this.port;
            try {
                this.port = this.port.length() == 0 ? "5480" : this.port;
                Integer.parseInt(this.port);
            }
            catch (NumberFormatException e) {
                this.port = null;
                this.printError("Invalid value for Port.");
            }
        }
        this.database = this.database == null || this.database.trim().length() == 0 ? this.getValue("Database(system)").trim() : this.database;
        this.database = this.database.length() == 0 ? "system" : this.database;
        this.user = this.user == null || this.user.trim().length() == 0 ? this.getValue("User(admin)").trim() : this.user;
        String string2 = this.user = this.user.length() == 0 ? "admin" : this.user;
        while ((this.password = this.getPassword()).trim().length() == 0) {
            this.printError("Password not specified.");
        }
        this.schema = this.schema == null || this.schema.trim().length() == 0 ? this.getValue("Schema").trim() : this.schema;
        this.schema = this.schema != null && this.schema.length() == 0 ? "" : this.schema;
        String secLevel = this.getValue("Security Level(" + (Object)((Object)NzSecurityLevel.getDefault()) + ")");
        this.securityLevel = secLevel == null || secLevel.trim().length() == 0 ? "" : secLevel;
        String caFile = this.getValue("Certificate file");
        this.caCertFile = caFile == null || caFile.trim().length() == 0 ? "" : caFile;
        this.loginModule = this.loginModule == null || this.loginModule.trim().length() == 0 ? this.getValue("Login module").trim() : this.loginModule;
        this.loginModule = this.loginModule.length() == 0 ? "" : this.loginModule;
        this.krbSSODelegation = this.krbSSODelegation == null || this.krbSSODelegation.trim().length() == 0 ? this.getValue("Kerberos SSO delegation(false)").trim() : this.krbSSODelegation;
        this.krbSSODelegation = this.krbSSODelegation.length() == 0 ? "false" : this.krbSSODelegation;
        this.applicationName = this.applicationName == null || this.applicationName.trim().length() == 0 ? this.getValue("Application name").trim() : this.applicationName;
        this.applicationName = this.applicationName.length() == 0 ? "" : this.applicationName;
        this.clientUser = this.clientUser == null || this.clientUser.trim().length() == 0 ? this.getValue("Client user").trim() : this.clientUser;
        this.clientUser = this.clientUser.length() == 0 ? "" : this.clientUser;
        this.clientHostName = this.clientHostName == null || this.clientHostName.trim().length() == 0 ? this.getValue("Client host name").trim() : this.clientHostName;
        this.clientHostName = this.clientHostName.length() == 0 ? "" : this.clientHostName;
        try {
            this.testConnection();
        }
        catch (SQLException e) {
            this.printError(e.getMessage());
            Main.exit();
        }
    }

    private void checkForError() {
        String error = null;
        switch (this.option) {
            case 1: {
                error = "Host name not specified";
                break;
            }
            case 2: {
                error = "Port not specified.";
                break;
            }
            case 3: {
                error = "Database name not specified.";
                break;
            }
            case 4: {
                error = "User name not specified.";
                break;
            }
            case 5: {
                error = "Password not specified.";
                break;
            }
            case 6: {
                error = "Security Level not specified.";
                break;
            }
            case 7: {
                error = "Certificate File not specified.";
                break;
            }
            case 9: {
                error = "Invalid entry for login module name.";
                break;
            }
            case 10: {
                error = "Invalid kerberos delegation SSO value provided.";
                break;
            }
            case -1: {
                break;
            }
            default: {
                error = "Unknown Error";
            }
        }
        if (error != null) {
            this.printError(error);
            Main.exit();
        }
    }

    private void testConnection() throws SQLException {
        String remote = this.host + (this.port.equals("") ? "" : ":" + this.port);
        String url = "jdbc:netezza://" + remote + "/" + this.database + ";";
        url = url + "securityLevel=" + this.securityLevel + ";" + "caCertFile=" + this.caCertFile + ";" + "krbLoginModule=" + this.loginModule + ";" + "krbSSODelegation=" + this.krbSSODelegation + ";" + "applicationName=" + this.applicationName + ";" + "clientUser=" + this.clientUser + ";" + "clientHostName=" + this.clientHostName + ";";
        if (this.schema != null && this.schema.length() > 0) {
            url = url + "schema=" + this.schema + ";";
        }
        try {
            Class.forName("org.netezza.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage());
        }
        Connection connection = DriverManager.getConnection(url, this.user, this.password);
        if (connection == null) {
            this.printError("Unknown Error");
            Main.exit();
        }
        this.nextLine();
        this.println("Success");
        this.println("NPS Product Version: " + connection.getMetaData().getDatabaseProductVersion());
        this.println("Netezza JDBC Driver Version: " + connection.getMetaData().getDriverVersion());
        this.nextLine();
        connection.close();
    }

    @Override
    public void help() {
        this.println("DESCRIPTION:\n\tTests a connection with a given database, user and password.\n\nUSAGE: \n\t[-t | --test] [option] [value] \n\nOPTIONS: \n\t--host, -h \n\t\tName of the host to connect to\n\n\t--port, -p \n\t\tPort number\n\n\t--database, -db \n\t\tDatabase (Catalog) name\n\n\t--user, -u \n\t\tUsername to connect to the database\n\n\t--password, -pw \n\t\tPassword for authentication\n\n\t--securitylevel, -s \n\t\tSecurity Level, used for secured connection.\n\n\t--schema, -S \n\t\tSchema name, used for connecting to specific schema.\n\n\t--cacertfile, -f \n\t\tCA certificate used for server certificate validation.\n\n\t--loginModule, -lm \n\t\tKerberos Login Module name present in login.conf file.\n\n\t--krbSSODelegation, -kssodel \n\t\ttrue if kerberos delegation application has been configured in Single Sign On mode and NPS is in Kerberos authentication mode.\n\n\t--help\n\t\tPrint this help\n\n\tNote:\n\t\tSome options have default value concatenated to them in parenthesis e.g.host(localhost)\n\t\tPress ENTER key to assign Default Value.");
    }
}

