/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.logging;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.netezza.Driver;
import org.netezza.internal.NzDriverExpiration;
import org.netezza.logging.BaseLogger;
import org.netezza.logging.LogLevel;

public class TextLogger
extends BaseLogger {
    private PrintWriter writer;
    private static final String TAB = "  ";
    private static final int TIMESTAMP_LENGTH = 20;
    private static final int CLASS_LENGTH = 18;
    private static final int METHOD_LENGTH = 20;
    private static final int LEVEL_LENGTH = 8;
    private static final int THREAD_ID_LENGTH = 10;

    public TextLogger(LogLevel level, String logDirPath) {
        super(level, logDirPath);
    }

    @Override
    protected String getExtension() {
        return "log";
    }

    @Override
    public void init() {
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.generateFileName(null);
        }
        try {
            this.writer = new PrintWriter(new FileOutputStream(this.fileName), true);
            this.writer.println("Operating System: " + OS);
            this.writer.println("Machine Architecture: " + MACHINE_ARCH);
            this.writer.println("OS version: " + OS_VERSION);
            this.writer.println("JRE version: " + JRE_VERSION);
            this.writer.println("Driver Version: " + Driver.getVersion());
            if (NzDriverExpiration.willDriverExpire()) {
                this.writer.println("Driver set to expire on: null");
            }
            this.writer.println("CLASSPATH: '" + System.getenv("CLASSPATH") + "'");
            this.writer.println("JAVA_HOME: '" + System.getenv("JAVA_HOME") + "'");
            this.writer.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void entry(Class klass, String method) {
        this.entry(klass, method, new Object[]{null});
    }

    @Override
    public void entry(Class klass, String method, Object ... params) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "ENTRY");
            this.writer.println(this.getParameterString(params));
        }
    }

    private void writeLog(Class klass, String method, String logType) {
        this.print(this.timeStamp(), 20);
        this.writer.print(TAB);
        this.print("[" + Thread.currentThread().hashCode() + "]", 10);
        this.writer.print(TAB);
        this.print(klass.getSimpleName(), 18);
        this.writer.print(TAB);
        this.print(method, 20);
        this.writer.print(TAB);
        this.print("[" + logType + "]", 8);
        this.writer.print(TAB);
    }

    @Override
    public void debug(Class klass, String method, Object message) {
        if (LogLevel.DEBUG.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "DEBUG");
            this.writer.println(message);
        }
    }

    @Override
    public void info(Class klass, String method, Object message) {
        if (LogLevel.INFO.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "INFO");
            this.writer.println(message);
        }
    }

    @Override
    public void fatal(Class klass, String method, Object message) {
        if (LogLevel.FATAL.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "FATAL");
            this.writer.println(message);
        }
    }

    @Override
    public void fatal(Class klass, String method, Throwable throwable) {
        if (LogLevel.FATAL.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "FATAL");
            this.writer.println("\n\n");
            throwable.printStackTrace(this.writer);
            this.writer.println("\n\n");
        }
    }

    @Override
    public void exit(Class klass, String method) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "EXIT");
            this.writer.println();
        }
    }

    @Override
    public void exit(Class klass, String method, Object returnParam) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.writer != null) {
            this.writeLog(klass, method, "EXIT");
            this.writer.println(this.getParameterString(returnParam));
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void print(Object message, int length) {
        if (message == null) {
            return;
        }
        String _message = message.toString().trim();
        int len = _message.length();
        if (len > length) {
            _message = _message.substring(0, length - 2);
            this.writer.print(_message + "..");
        } else if (len < length) {
            int diff = length - len;
            this.writer.print(_message);
            for (int i = 0; i < diff; ++i) {
                this.writer.print(" ");
            }
        } else {
            this.writer.print(_message);
        }
    }
}

