/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.error;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MessageTranslator {
    private static MessageTranslator instance = null;
    private static Locale locale = Locale.DEFAULT;
    private Properties prop;

    private MessageTranslator(String resourceName) {
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream(resourceName);
            this.prop = new Properties();
            this.prop.load(new BufferedInputStream(stream));
        }
        catch (FileNotFoundException e) {
            this.prop = null;
        }
        catch (IOException e) {
            this.prop = null;
        }
    }

    private static final synchronized MessageTranslator getInstance() {
        if (instance == null) {
            instance = new MessageTranslator(locale.getResourceName());
        }
        return instance;
    }

    private static final void setLocale(String localeName) {
        locale = localeName != null ? Locale.valueOf(localeName.toUpperCase()) : Locale.DEFAULT;
    }

    public static final String translate(String id, Object ... args) {
        MessageTranslator translator = MessageTranslator.getInstance();
        return translator._translate(id, args);
    }

    public static final String translate(String id, String localeName, Object ... args) {
        MessageTranslator.setLocale(localeName);
        return MessageTranslator.translate(id, args);
    }

    private final String _translate(String id, Object ... args) {
        String message;
        if (this.prop != null && id != null) {
            message = this.prop.getProperty(id);
            message = args != null && message != null ? this.format(message, args) : id;
        } else {
            message = id;
        }
        return message;
    }

    private String format(String message, Object ... arguments) {
        StringBuilder formattedMSG = new StringBuilder();
        boolean isDelimiter = false;
        for (char ch : message.toCharArray()) {
            if (ch == '{') {
                isDelimiter = true;
                continue;
            }
            if (isDelimiter && Character.isDigit(ch)) {
                formattedMSG.append(arguments[ch - 48]);
                continue;
            }
            if (ch == '}') {
                isDelimiter = false;
                continue;
            }
            formattedMSG.append(ch);
        }
        return formattedMSG.toString();
    }

    private static enum Locale {
        DEFAULT("en_us", "org/netezza/error/errors.properties"),
        DE("de", "org/netezza/error/errors_de.properties"),
        FR("fr", "org/netezza/error/errors_fr.properties"),
        IT("it", "org/netezza/error/errors_it.properties"),
        NL("nl", "org/netezza/error/errors_nl.properties"),
        EN_US("en_us", "org/netezza/error/errors.properties"),
        ZH_TW("zh_TW", "org/netezza/error/errors_zh_TW.properties");

        private MessageTranslator msgTralnslator;
        private String localeName;
        private String resourceName;

        private Locale(String localeName, String resourceName) {
            this.localeName = localeName;
            this.resourceName = resourceName;
        }

        public String getLocaleName() {
            return this.localeName;
        }

        public MessageTranslator getMessageTranslator() {
            return this.msgTralnslator;
        }

        public void setMessageTranslator(MessageTranslator msgTralnslator) {
            this.msgTralnslator = msgTralnslator;
        }

        public static Locale getDefault() {
            return EN_US;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }
    }
}

