/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.utils.CommonUtils;

public class VerticaSQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final String[][] VERTICA_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"CASE", "END"}, {"LOOP", "END LOOP"}};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private static final String[] VERTICA_BLOCK_HEADERS = new String[]{"DECLARE"};
    private static String[] VERTICA_KEYWORDS = new String[]{"BIT", "CACHE", "COMMENT", "CORRELATION", "ENCODED", "FLEX", "ILIKE", "ILIKEB", "INTERVALYM", "ISNULL", "KSAFE", "LIKEB", "MINUS", "MONEY", "NCHAR", "NOTNULL", "NULLSEQUAL", "OFFSET", "PINNED", "PROJECTION", "SMALLDATETIME", "TEXT", "TIMESERIES", "TIMEZONE", "TINYINT", "UUID", "VARCHAR2", "EXPLAIN", "VERBOSE", "JSON"};
    private static String[] VERTICA_FUNCTIONS = new String[]{"CURRENT_DATABASE", "CURRENT_SCHEMA", "DATEDIFF", "DATETIME", "DECODE"};

    public VerticaSQLDialect() {
        super("Vertica", "vertica");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList(VERTICA_KEYWORDS));
        this.addFunctions(Arrays.asList(VERTICA_FUNCTIONS));
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        return BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> left + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }

    public String[][] getBlockBoundStrings() {
        return VERTICA_BEGIN_END_BLOCK;
    }

    public String[] getBlockHeaderStrings() {
        return VERTICA_BLOCK_HEADERS;
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            return new TPRule[]{new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, false, false, dataSource == null || CommonUtils.toBoolean((Object)dataSource.getConnectionConfiguration().getProviderProperty("dollar-quotes-as-string@")))};
        }
        return new TPRule[0];
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }
}

