/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.registry.maven.MavenArtifactVersion;
import org.jkiss.dbeaver.registry.maven.MavenRepository;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MavenRegistry {
    private static final Log log = Log.getLog(MavenRegistry.class);
    public static final String MAVEN_LOCAL_REPO_ID = "local";
    public static final String MAVEN_LOCAL_REPO_NAME = "Local Repository";
    public static final String MAVEN_LOCAL_REPO_FOLDER = "maven-local";
    public static final String MAVEN_REPOSITORIES_CONFIG = "maven-repositories.xml";
    private static MavenRegistry instance = null;
    private final List<String> ignoredArtifactVersions = new ArrayList<String>();
    private final List<MavenRepository> repositories = new ArrayList<MavenRepository>();
    private MavenRepository localRepository;
    private final Set<String> notFoundArtifacts = new HashSet<String>();
    private static final PasswordEncrypter ENCRYPTOR = new SimpleStringEncrypter();

    public static synchronized MavenRegistry getInstance() {
        if (instance == null) {
            instance = new MavenRegistry();
            instance.init();
        }
        return instance;
    }

    private MavenRegistry() {
    }

    boolean isVersionIgnored(String ref) {
        for (String ver : this.ignoredArtifactVersions) {
            if (!ref.startsWith(ver)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.loadStandardRepositories();
        this.loadCustomRepositories();
        this.sortRepositories();
    }

    private void loadStandardRepositories() {
        Object localRepoURL;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.jkiss.dbeaver.mavenRepository");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("repository".equals(ext.getName())) {
                MavenRepository repository = new MavenRepository(ext);
                this.repositories.add(repository);
            } else if ("ignoreArtifactVersion".equals(ext.getName())) {
                this.ignoredArtifactVersions.add(ext.getAttribute("id"));
            }
            ++n2;
        }
        try {
            localRepoURL = Platform.getInstallLocation().getDataArea(MAVEN_LOCAL_REPO_FOLDER).toString();
        }
        catch (IOException iOException) {
            localRepoURL = Platform.getInstallLocation().getURL().toString() + "/maven-local";
        }
        this.localRepository = new MavenRepository(MAVEN_LOCAL_REPO_ID, MAVEN_LOCAL_REPO_NAME, (String)localRepoURL, MavenRepository.RepositoryType.LOCAL);
    }

    public void setCustomRepositories(List<MavenRepository> customRepositories) {
        this.notFoundArtifacts.clear();
        Iterator<MavenRepository> iter = this.repositories.iterator();
        while (iter.hasNext()) {
            if (iter.next().getType() != MavenRepository.RepositoryType.CUSTOM) continue;
            iter.remove();
        }
        this.repositories.addAll(customRepositories);
        this.sortRepositories();
    }

    public void loadCustomRepositories() {
        try {
            String config = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(MAVEN_REPOSITORIES_CONFIG);
            if (CommonUtils.isEmpty((String)config)) {
                return;
            }
            Document reposDocument = XMLUtils.parseDocument((Reader)new StringReader(config));
            for (Element repoElement : XMLUtils.getChildElementList((Element)reposDocument.getDocumentElement(), (String)"repository")) {
                String repoID = repoElement.getAttribute("id");
                MavenRepository repo = this.findRepository(repoID);
                if (repo == null) {
                    String repoName = repoElement.getAttribute("name");
                    String repoURL = repoElement.getAttribute("url");
                    repo = new MavenRepository(repoID, repoName, repoURL, MavenRepository.RepositoryType.CUSTOM);
                    boolean snapshot = CommonUtils.toBoolean((Object)repoElement.getAttribute("snapshot"));
                    repo.setIsSnapshot(snapshot);
                    ArrayList<String> scopes = new ArrayList<String>();
                    for (Element scopeElement : XMLUtils.getChildElementList((Element)repoElement, (String)"scope")) {
                        scopes.add(scopeElement.getAttribute("group"));
                    }
                    repo.setScopes(scopes);
                    this.repositories.add(repo);
                }
                repo.setOrder(CommonUtils.toInt((Object)repoElement.getAttribute("order")));
                repo.setEnabled(CommonUtils.toBoolean((Object)repoElement.getAttribute("enabled")));
                String authUser = repoElement.getAttribute("auth-user");
                if (CommonUtils.isEmpty((String)authUser)) continue;
                repo.getAuthInfo().setUserName(authUser);
                String authPassword = repoElement.getAttribute("auth-password");
                if (CommonUtils.isEmpty((String)authPassword)) continue;
                repo.getAuthInfo().setUserPassword(ENCRYPTOR.decrypt(authPassword));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error parsing maven repositories configuration", (Throwable)e);
        }
    }

    @NotNull
    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    @Nullable
    public MavenArtifactVersion findArtifact(@NotNull DBRProgressMonitor monitor, @Nullable MavenArtifactVersion owner, @NotNull MavenArtifactReference ref) {
        String fullId = ref.getId();
        if (this.notFoundArtifacts.contains(fullId)) {
            return null;
        }
        MavenArtifactVersion artifact = this.findInRepositories(monitor, owner, ref);
        if (artifact != null) {
            return artifact;
        }
        this.notFoundArtifacts.add(fullId);
        return null;
    }

    public void resetArtifactInfo(MavenArtifactReference artifactReference) {
        this.notFoundArtifacts.remove(artifactReference.getId());
        for (MavenRepository repository : this.repositories) {
            repository.resetArtifactCache(artifactReference);
        }
        this.localRepository.resetArtifactCache(artifactReference);
    }

    @Nullable
    private MavenArtifactVersion findInRepositories(@NotNull DBRProgressMonitor monitor, MavenArtifactVersion owner, @NotNull MavenArtifactReference ref) {
        MavenArtifactVersion artifact;
        MavenArtifactVersion artifact2;
        MavenRepository currentRepository;
        MavenRepository mavenRepository = currentRepository = owner == null ? null : owner.getArtifact().getRepository();
        if (currentRepository != null && (artifact2 = currentRepository.findArtifact(monitor, ref)) != null) {
            return artifact2;
        }
        for (MavenRepository repository : this.repositories) {
            if (!repository.isEnabled() || repository == currentRepository || !repository.getScopes().isEmpty() && !repository.getScopes().contains(ref.getGroupId()) || (artifact = repository.findArtifact(monitor, ref)) == null) continue;
            return artifact;
        }
        if (owner != null) {
            for (MavenRepository repository : owner.getActiveRepositories()) {
                if (repository == currentRepository || (artifact = repository.findArtifact(monitor, ref)) == null) continue;
                return artifact;
            }
        }
        if (this.localRepository != currentRepository && (artifact2 = this.localRepository.findArtifact(monitor, ref)) != null) {
            return artifact2;
        }
        log.warn((Object)("Maven artifact '" + String.valueOf(ref) + "' not found in any available repository."));
        return null;
    }

    public MavenRepository findRepository(String id) {
        for (MavenRepository repository : this.repositories) {
            if (!repository.getId().equals(id)) continue;
            return repository;
        }
        return null;
    }

    public void saveConfiguration() {
        this.sortRepositories();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLBuilder xml = new XMLBuilder((OutputStream)baos, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            Throwable throwable = null;
            Object var4_6 = null;
            try (XMLBuilder.Element e1 = xml.startElement("maven");){
                for (MavenRepository repository : this.repositories) {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (XMLBuilder.Element e2 = xml.startElement("repository");){
                        xml.addAttribute("id", repository.getId());
                        xml.addAttribute("order", repository.getOrder());
                        xml.addAttribute("enabled", repository.isEnabled());
                        if (repository.getType() == MavenRepository.RepositoryType.GLOBAL) continue;
                        xml.addAttribute("url", repository.getUrl());
                        xml.addAttribute("name", repository.getName());
                        if (!CommonUtils.isEmpty((String)repository.getDescription())) {
                            xml.addAttribute("description", repository.getDescription());
                        }
                        for (String scope : repository.getScopes()) {
                            Throwable throwable3 = null;
                            Object var14_20 = null;
                            try (XMLBuilder.Element e3 = xml.startElement("scope");){
                                xml.addAttribute("group", scope);
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        xml.addAttribute("snapshot", repository.isSnapshot());
                        DBPAuthInfo authInfo = repository.getAuthInfo();
                        if (CommonUtils.isEmpty((String)authInfo.getUserName())) continue;
                        xml.addAttribute("auth-user", authInfo.getUserName());
                        if (CommonUtils.isEmpty((String)authInfo.getUserPassword())) continue;
                        xml.addAttribute("auth-password", ENCRYPTOR.encrypt(authInfo.getUserPassword()));
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            xml.flush();
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(MAVEN_REPOSITORIES_CONFIG, baos.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error((Object)"Error saving Maven registry", (Throwable)e);
        }
    }

    private void sortRepositories() {
        this.repositories.sort(Comparator.comparingInt(MavenRepository::getOrder));
    }
}

