/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.utils.ArrayUtils;

public class DriverLibraryRemote
extends DriverLibraryLocal {
    private static final Log log = Log.getLog(DriverLibraryRemote.class);
    public static final String DOWNLOAD_DIR = "remote";
    public static final String[] SUPPORTED_PROTOCOLS = new String[]{"http", "https", "ftp"};

    public DriverLibraryRemote(DriverDescriptor driver, DBPDriverLibrary.FileType type, String url) {
        super(driver, type, url);
    }

    public DriverLibraryRemote(DriverDescriptor driver, IConfigurationElement config) {
        super(driver, config);
    }

    private DriverLibraryRemote(DriverDescriptor driver, DriverLibraryRemote copyFrom) {
        super(driver, copyFrom);
    }

    @Override
    public DBPDriverLibrary copyLibrary(DriverDescriptor driverDescriptor) {
        return new DriverLibraryRemote(driverDescriptor, this);
    }

    @Override
    public boolean isDownloadable() {
        return true;
    }

    @Override
    protected String getLocalFilePath() {
        try {
            String path = new URL(this.getPath()).getPath();
            if (path.startsWith("/")) {
                return DOWNLOAD_DIR + path;
            }
            return "remote/" + path;
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            return this.getPath();
        }
    }

    @Override
    @Nullable
    public String getExternalURL(DBRProgressMonitor monitor) {
        return this.getPath();
    }

    public static boolean supportsURL(String url) {
        int pos = url.indexOf(":/");
        if (pos <= 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])SUPPORTED_PROTOCOLS, (Object)url.substring(0, pos));
    }
}

